/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.iterator.CopyConstructorIterator;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.stochasticsvd.GivensThinSolver;
import org.apache.mahout.math.hadoop.stochasticsvd.Omega;
import org.apache.mahout.math.hadoop.stochasticsvd.PartialRowEmitter;
import org.apache.mahout.math.hadoop.stochasticsvd.UpperTriangular;
import org.apache.mahout.math.ssvd.EigenSolverWrapper;

public class SSVDPrototype {
    private final Omega omega;
    private final int kp;
    private GivensThinSolver qSolver;
    private final double[] yRow;
    private int cnt;
    private int blckCnt;
    private final int r;
    private final List<UpperTriangular> rBlocks = new ArrayList<UpperTriangular>();
    private final List<double[][]> qtBlocks = new ArrayList<double[][]>();
    private final List<double[]> yLookahead;

    public SSVDPrototype(long seed, int kp, int r) {
        this.kp = kp;
        this.omega = new Omega(seed, kp / 2, kp - kp / 2);
        this.yRow = new double[kp];
        this.r = r;
        this.yLookahead = new ArrayList<double[]>(kp);
    }

    void firstPass(Vector aRow) {
        this.omega.computeYRow(aRow, this.yRow);
        this.yLookahead.add((double[])this.yRow.clone());
        while (this.yLookahead.size() > this.kp) {
            if (this.qSolver == null) {
                this.qSolver = new GivensThinSolver(this.r, this.kp);
            }
            this.qSolver.appendRow(this.yLookahead.remove(0));
            if (!this.qSolver.isFull()) continue;
            UpperTriangular r = this.qSolver.getRTilde();
            double[][] qt = this.qSolver.getThinQtTilde();
            this.qSolver = null;
            this.qtBlocks.add(qt);
            this.rBlocks.add(r);
        }
        ++this.cnt;
    }

    void finishFirstPass() {
        if (this.qSolver == null && this.yLookahead.isEmpty()) {
            return;
        }
        if (this.qSolver == null) {
            this.qSolver = new GivensThinSolver(this.yLookahead.size(), this.kp);
        }
        this.qSolver.adjust(this.qSolver.getCnt() + this.yLookahead.size());
        while (!this.yLookahead.isEmpty()) {
            this.qSolver.appendRow(this.yLookahead.remove(0));
            if (!this.qSolver.isFull()) continue;
            UpperTriangular r = this.qSolver.getRTilde();
            double[][] qt = this.qSolver.getThinQtTilde();
            this.qSolver = null;
            this.qtBlocks.add(qt);
            this.rBlocks.add(r);
        }
        for (int i = 0; i < this.rBlocks.size(); ++i) {
            this.qtBlocks.set(i, GivensThinSolver.computeQtHat(this.qtBlocks.get(i), i, new CopyConstructorIterator<UpperTriangular>(this.rBlocks.listIterator())));
        }
        this.cnt = 0;
        this.blckCnt = 0;
    }

    void secondPass(Vector aRow, PartialRowEmitter btEmitter) throws IOException {
        int n = aRow.size();
        double[][] qtHat = this.qtBlocks.get(this.blckCnt);
        int r = qtHat[0].length;
        int qRowBlckIndex = r - this.cnt - 1;
        double[] qRow = new double[this.kp];
        for (int i = 0; i < this.kp; ++i) {
            qRow[i] = qtHat[i][qRowBlckIndex];
        }
        DenseVector qRowV = new DenseVector(qRow, true);
        if (++this.cnt == r) {
            ++this.blckCnt;
            this.cnt = 0;
        }
        for (int i = 0; i < n; ++i) {
            btEmitter.emitRow(i, qRowV.times(aRow.getQuick(i)));
        }
    }

    public static void testThinQr(int dims, int kp) throws IOException {
        int i;
        int i2;
        DenseMatrix mx = new DenseMatrix(dims << 2, dims);
        Random rnd = RandomUtils.getRandom();
        for (int i3 = 0; i3 < mx.rowSize(); ++i3) {
            for (int j = 0; j < mx.columnSize(); ++j) {
                mx.set(i3, j, rnd.nextDouble() * 1000.0);
            }
        }
        mx.setQuick(0, 0, 1.0);
        mx.setQuick(0, 1, 2.0);
        mx.setQuick(0, 2, 3.0);
        mx.setQuick(1, 0, 4.0);
        mx.setQuick(1, 1, 5.0);
        mx.setQuick(1, 2, 6.0);
        mx.setQuick(2, 0, 7.0);
        mx.setQuick(2, 1, 8.0);
        mx.setQuick(2, 2, 9.0);
        SingularValueDecomposition svd2 = new SingularValueDecomposition((Matrix)mx);
        double[] svaluesControl = svd2.getSingularValues();
        for (int i4 = 0; i4 < kp; ++i4) {
            System.out.printf("%.3e ", svaluesControl[i4]);
        }
        System.out.println();
        int m = mx.rowSize();
        long seed = RandomUtils.getRandom().nextLong();
        final HashMap btRows = new HashMap();
        PartialRowEmitter btEmitter = new PartialRowEmitter(){

            @Override
            public void emitRow(int rowNum, Vector row) {
                Vector btRow = (Vector)btRows.get(rowNum);
                if (btRow != null) {
                    row.addTo(btRow);
                }
                btRows.put(rowNum, btRow == null ? new DenseVector(row) : btRow);
            }
        };
        SSVDPrototype mapperSimulation = new SSVDPrototype(seed, kp, 3000);
        for (i2 = 0; i2 < m; ++i2) {
            mapperSimulation.firstPass(mx.getRow(i2));
        }
        mapperSimulation.finishFirstPass();
        for (i2 = 0; i2 < m; ++i2) {
            mapperSimulation.secondPass(mx.getRow(i2), btEmitter);
        }
        final HashMap bbt = new HashMap();
        PartialRowEmitter bbtEmitter = new PartialRowEmitter(){

            @Override
            public void emitRow(int rowNum, Vector row) {
                Vector bbtRow = (Vector)bbt.get(rowNum);
                if (bbtRow != null) {
                    row.addTo(bbtRow);
                }
                bbt.put(rowNum, bbtRow == null ? new DenseVector(row) : bbtRow);
            }
        };
        for (Map.Entry btRowEntry : btRows.entrySet()) {
            Vector btRow = (Vector)btRowEntry.getValue();
            assert (btRow.size() == kp);
            for (int i5 = 0; i5 < kp; ++i5) {
                bbtEmitter.emitRow(i5, btRow.times(btRow.getQuick(i5)));
            }
        }
        double[][] bbtValues = new double[kp][];
        for (int i6 = 0; i6 < kp; ++i6) {
            bbtValues[i6] = new double[kp];
            Vector bbtRow = (Vector)bbt.get(i6);
            for (int j = 0; j < kp; ++j) {
                bbtValues[i6][j] = bbtRow.getQuick(j);
            }
        }
        EigenSolverWrapper eigenWrapper = new EigenSolverWrapper((double[][])bbtValues);
        double[] eigenva2 = eigenWrapper.getEigenValues();
        double[] svalues = new double[kp];
        for (i = 0; i < kp; ++i) {
            svalues[i] = Math.sqrt(eigenva2[i]);
        }
        for (i = 0; i < kp; ++i) {
            System.out.printf("%.3e ", svalues[i]);
        }
        System.out.println();
    }

    public static void testBlockQrWithSSVD(int dims, int kp, int r, long rndSeed) throws IOException {
        int i;
        int i2;
        DenseMatrix mx = new DenseMatrix(dims << 2, dims);
        Random rnd = RandomUtils.getRandom();
        for (int i3 = 0; i3 < mx.rowSize(); ++i3) {
            for (int j = 0; j < mx.columnSize(); ++j) {
                mx.set(i3, j, (rnd.nextDouble() - 0.5) * 1000.0);
            }
        }
        mx.setQuick(0, 0, 1.0);
        mx.setQuick(0, 1, 2.0);
        mx.setQuick(0, 2, 3.0);
        mx.setQuick(1, 0, 4.0);
        mx.setQuick(1, 1, 5.0);
        mx.setQuick(1, 2, 6.0);
        mx.setQuick(2, 0, 7.0);
        mx.setQuick(2, 1, 8.0);
        mx.setQuick(2, 2, 9.0);
        SingularValueDecomposition svd2 = new SingularValueDecomposition((Matrix)mx);
        double[] svaluesControl = svd2.getSingularValues();
        for (int i4 = 0; i4 < kp; ++i4) {
            System.out.printf("%e ", svaluesControl[i4]);
        }
        System.out.println();
        int m = mx.rowSize();
        final HashMap btRows = new HashMap();
        PartialRowEmitter btEmitter = new PartialRowEmitter(){

            @Override
            public void emitRow(int rowNum, Vector row) {
                Vector btRow = (Vector)btRows.get(rowNum);
                if (btRow != null) {
                    row.addTo(btRow);
                }
                btRows.put(rowNum, btRow == null ? new DenseVector(row) : btRow);
            }
        };
        SSVDPrototype mapperSimulation = new SSVDPrototype(rndSeed, kp, r);
        for (i2 = 0; i2 < m; ++i2) {
            mapperSimulation.firstPass(mx.getRow(i2));
        }
        mapperSimulation.finishFirstPass();
        for (i2 = 0; i2 < m; ++i2) {
            mapperSimulation.secondPass(mx.getRow(i2), btEmitter);
        }
        final HashMap bbt = new HashMap();
        PartialRowEmitter bbtEmitter = new PartialRowEmitter(){

            @Override
            public void emitRow(int rowNum, Vector row) {
                Vector bbtRow = (Vector)bbt.get(rowNum);
                if (bbtRow != null) {
                    row.addTo(bbtRow);
                }
                bbt.put(rowNum, bbtRow == null ? new DenseVector(row) : bbtRow);
            }
        };
        for (Map.Entry btRowEntry : btRows.entrySet()) {
            Vector btRow = (Vector)btRowEntry.getValue();
            assert (btRow.size() == kp);
            for (int i5 = 0; i5 < kp; ++i5) {
                bbtEmitter.emitRow(i5, btRow.times(btRow.getQuick(i5)));
            }
        }
        double[][] bbtValues = new double[kp][];
        for (int i6 = 0; i6 < kp; ++i6) {
            bbtValues[i6] = new double[kp];
            Vector bbtRow = (Vector)bbt.get(i6);
            for (int j = 0; j < kp; ++j) {
                bbtValues[i6][j] = bbtRow.getQuick(j);
            }
        }
        EigenSolverWrapper eigenWrapper = new EigenSolverWrapper((double[][])bbtValues);
        double[] eigenva2 = eigenWrapper.getEigenValues();
        double[] svalues = new double[kp];
        for (i = 0; i < kp; ++i) {
            svalues[i] = Math.sqrt(eigenva2[i]);
        }
        for (i = 0; i < kp; ++i) {
            System.out.printf("%e ", svalues[i]);
        }
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        long seed = RandomUtils.getRandom().nextLong();
        SSVDPrototype.testBlockQrWithSSVD(200, 200, 800, seed);
        SSVDPrototype.testBlockQrWithSSVD(200, 20, 800, seed);
        SSVDPrototype.testBlockQrWithSSVD(200, 20, 850, seed);
        SSVDPrototype.testBlockQrWithSSVD(200, 20, 90, seed);
        SSVDPrototype.testBlockQrWithSSVD(200, 20, 99, seed);
    }
}

