/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDSolver;

public class SSVDCli
extends AbstractJob {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        FileStatus[] vFiles;
        FileStatus[] uFiles;
        this.addInputOption();
        this.addOutputOption();
        this.addOption("rank", "k", "decomposition rank", true);
        this.addOption("oversampling", "p", "oversampling", true);
        this.addOption("blockHeight", "r", "Y block height (must be > (k+p))", true);
        this.addOption("minSplitSize", "s", "minimum split size", "-1");
        this.addOption("computeU", "U", "compute U (true/false)", "true");
        this.addOption("uHalfSigma", "uhs", "Compute U as UHat=U x pow(Sigma,0.5)", "false");
        this.addOption("computeV", "V", "compute V (true/false)", "true");
        this.addOption("vHalfSigma", "vhs", "compute V as VHat= V x pow(Sigma,0.5)", "false");
        this.addOption("reduceTasks", "t", "number of reduce tasks (where applicable)", "1");
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        Map<String, String> pargs = this.parseArguments(args);
        if (pargs == null) {
            return -1;
        }
        String input = pargs.get("--input");
        String output = pargs.get("--output");
        String tempDir = pargs.get("--tempDir");
        int k = Integer.parseInt(pargs.get("--rank"));
        int p = Integer.parseInt(pargs.get("--oversampling"));
        int r = Integer.parseInt(pargs.get("--blockHeight"));
        int minSplitSize = Integer.parseInt(pargs.get("--minSplitSize"));
        boolean computeU = Boolean.parseBoolean(pargs.get("--computeU"));
        boolean computeV = Boolean.parseBoolean(pargs.get("--computeV"));
        boolean cUHalfSigma = Boolean.parseBoolean(pargs.get("--uHalfSigma"));
        boolean cVHalfSigma = Boolean.parseBoolean(pargs.get("--vHalfSigma"));
        int reduceTasks = Integer.parseInt(pargs.get("--reduceTasks"));
        boolean overwrite = pargs.containsKey(SSVDCli.keyFor("overwrite"));
        Configuration conf = this.getConf();
        if (conf == null) {
            throw new IOException("No Hadoop configuration present");
        }
        SSVDSolver solver = new SSVDSolver(conf, new Path[]{new Path(input)}, new Path(tempDir), r, k, p, reduceTasks);
        solver.setMinSplitSize(minSplitSize);
        solver.setComputeU(computeU);
        solver.setComputeV(computeV);
        solver.setcUHalfSigma(cUHalfSigma);
        solver.setcVHalfSigma(cVHalfSigma);
        solver.setOverwrite(overwrite);
        solver.run();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path outPath = new Path(output);
        fs.mkdirs(outPath);
        SequenceFile.Writer sigmaW = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)new Path(outPath, "sigma"), NullWritable.class, VectorWritable.class);
        try {
            VectorWritable sValues = new VectorWritable((Vector)new DenseVector(Arrays.copyOf(solver.getSingularValues(), k), true));
            sigmaW.append((Writable)NullWritable.get(), (Writable)sValues);
        }
        finally {
            sigmaW.close();
        }
        if (computeU && (uFiles = fs.globStatus(new Path(solver.getUPath()))) != null) {
            for (FileStatus uf : uFiles) {
                fs.rename(uf.getPath(), outPath);
            }
        }
        if (computeV && (vFiles = fs.globStatus(new Path(solver.getVPath()))) != null) {
            for (FileStatus vf : vFiles) {
                fs.rename(vf.getPath(), outPath);
            }
        }
        return 0;
    }

    public static int main(String[] args) throws Exception {
        return ToolRunner.run((Tool)new SSVDCli(), (String[])args);
    }
}

