/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.MultipleOutputs;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.iterator.CopyConstructorIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.DenseBlockWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.GivensThinSolver;
import org.apache.mahout.math.hadoop.stochasticsvd.Omega;
import org.apache.mahout.math.hadoop.stochasticsvd.UpperTriangular;

public final class QJob {
    public static final String PROP_OMEGA_SEED = "ssvd.omegaseed";
    public static final String PROP_K = "ssvd.k";
    public static final String PROP_P = "ssvd.p";
    public static final String PROP_AROWBLOCK_SIZE = "ssvd.arowblock.size";
    public static final String OUTPUT_R = "R";
    public static final String OUTPUT_QHAT = "QHat";

    private QJob() {
    }

    public static void run(Configuration conf, Path[] inputPaths, Path outputPath, int aBlockRows, int minSplitSize, int k, int p, long seed, int numReduceTasks) throws ClassNotFoundException, InterruptedException, IOException {
        JobConf oldApiJob = new JobConf(conf);
        MultipleOutputs.addNamedOutput((JobConf)oldApiJob, (String)OUTPUT_QHAT, SequenceFileOutputFormat.class, QJobKeyWritable.class, DenseBlockWritable.class);
        MultipleOutputs.addNamedOutput((JobConf)oldApiJob, (String)OUTPUT_R, SequenceFileOutputFormat.class, QJobKeyWritable.class, VectorWritable.class);
        Job job = new Job((Configuration)oldApiJob);
        job.setJobName("Q-job");
        job.setJarByClass(QJob.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])inputPaths);
        if (minSplitSize > 0) {
            FileInputFormat.setMinInputSplitSize((Job)job, (long)minSplitSize);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        FileOutputFormat.setOutputCompressorClass((Job)job, DefaultCodec.class);
        org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        job.setMapOutputKeyClass(QJobKeyWritable.class);
        job.setMapOutputValueClass(VectorWritable.class);
        job.setOutputKeyClass(QJobKeyWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setMapperClass(QMapper.class);
        job.getConfiguration().setInt(PROP_AROWBLOCK_SIZE, aBlockRows);
        job.getConfiguration().setLong(PROP_OMEGA_SEED, seed);
        job.getConfiguration().setInt(PROP_K, k);
        job.getConfiguration().setInt(PROP_P, p);
        job.setNumReduceTasks(0);
        job.submit();
        job.waitForCompletion(false);
        if (!job.isSuccessful()) {
            throw new IOException("Q job unsuccessful.");
        }
    }

    public static class QMapper
    extends Mapper<Writable, VectorWritable, QJobKeyWritable, VectorWritable> {
        private int kp;
        private Omega omega;
        private List<double[]> yLookahead;
        private GivensThinSolver qSolver;
        private int blockCnt;
        private int r;
        private final DenseBlockWritable value = new DenseBlockWritable();
        private final QJobKeyWritable key = new QJobKeyWritable();
        private final Writable tempKey = new IntWritable();
        private MultipleOutputs outputs;
        private final Deque<Closeable> closeables = new LinkedList<Closeable>();
        private SequenceFile.Writer tempQw;
        private Path tempQPath;
        private final List<UpperTriangular> rSubseq = new ArrayList<UpperTriangular>();

        private void flushSolver(Mapper.Context context) throws IOException {
            UpperTriangular r = this.qSolver.getRTilde();
            double[][] qt = this.qSolver.getThinQtTilde();
            this.rSubseq.add(r);
            this.value.setBlock(qt);
            this.getTempQw(context).append(this.tempKey, (Writable)this.value);
            this.value.setBlock(null);
            this.qSolver.reset();
        }

        private void flushQBlocks(Mapper.Context ctx) throws IOException {
            if (this.blockCnt == 1) {
                this.value.setBlock(this.qSolver.getThinQtTilde());
                this.outputQHat((Writable)this.key, this.value);
                this.outputR((Writable)this.key, new VectorWritable((Vector)new DenseVector(this.qSolver.getRTilde().getData(), true)));
            } else {
                this.secondPass(ctx);
            }
        }

        private void outputQHat(Writable key, Writable value) throws IOException {
            this.outputs.getCollector(QJob.OUTPUT_QHAT, null).collect((Object)key, (Object)value);
        }

        private void outputR(Writable key, Writable value) throws IOException {
            this.outputs.getCollector(QJob.OUTPUT_R, null).collect((Object)key, (Object)value);
        }

        private void secondPass(Mapper.Context ctx) throws IOException {
            this.qSolver = null;
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)ctx.getConfiguration());
            SequenceFile.Reader tempQr = new SequenceFile.Reader((FileSystem)localFs, this.tempQPath, ctx.getConfiguration());
            this.closeables.addFirst((Closeable)tempQr);
            int qCnt = 0;
            while (tempQr.next(this.tempKey, (Writable)this.value)) {
                this.value.setBlock(GivensThinSolver.computeQtHat(this.value.getBlock(), qCnt, new CopyConstructorIterator<UpperTriangular>(this.rSubseq.iterator())));
                if (qCnt == 1) {
                    GivensThinSolver.mergeR(this.rSubseq.get(0), this.rSubseq.remove(1));
                } else {
                    ++qCnt;
                }
                this.outputQHat((Writable)this.key, this.value);
            }
            assert (this.rSubseq.size() == 1);
            this.outputR((Writable)this.key, new VectorWritable((Vector)new DenseVector(this.rSubseq.get(0).getData(), true)));
        }

        protected void map(Writable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            double[] yRow;
            if (this.yLookahead.size() == this.kp) {
                if (this.qSolver.isFull()) {
                    this.flushSolver(context);
                    ++this.blockCnt;
                }
                yRow = this.yLookahead.remove(0);
                this.qSolver.appendRow(yRow);
            } else {
                yRow = new double[this.kp];
            }
            this.omega.computeYRow(value.get(), yRow);
            this.yLookahead.add(yRow);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            int k = Integer.parseInt(context.getConfiguration().get(QJob.PROP_K));
            int p = Integer.parseInt(context.getConfiguration().get(QJob.PROP_P));
            this.kp = k + p;
            long omegaSeed = Long.parseLong(context.getConfiguration().get(QJob.PROP_OMEGA_SEED));
            this.r = Integer.parseInt(context.getConfiguration().get(QJob.PROP_AROWBLOCK_SIZE));
            this.omega = new Omega(omegaSeed, k, p);
            this.yLookahead = new ArrayList<double[]>(this.kp);
            this.qSolver = new GivensThinSolver(this.r, this.kp);
            this.outputs = new MultipleOutputs(new JobConf(context.getConfiguration()));
            this.closeables.addFirst(new Closeable(){

                @Override
                public void close() throws IOException {
                    QMapper.this.outputs.close();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            try {
                if (this.qSolver == null && this.yLookahead.isEmpty()) {
                    return;
                }
                if (this.qSolver == null) {
                    this.qSolver = new GivensThinSolver(this.yLookahead.size(), this.kp);
                }
                this.qSolver.adjust(this.qSolver.getCnt() + this.yLookahead.size());
                while (!this.yLookahead.isEmpty()) {
                    this.qSolver.appendRow(this.yLookahead.remove(0));
                }
                assert (this.qSolver.isFull());
                if (++this.blockCnt > 1) {
                    this.flushSolver(context);
                    assert (this.tempQw != null);
                    this.closeables.remove(this.tempQw);
                    this.tempQw.close();
                }
                this.flushQBlocks(context);
            }
            finally {
                IOUtils.close(this.closeables);
            }
        }

        private SequenceFile.Writer getTempQw(Mapper.Context context) throws IOException {
            if (this.tempQw == null) {
                String taskTmpDir = System.getProperty("java.io.tmpdir");
                LocalFileSystem localFs = FileSystem.getLocal((Configuration)context.getConfiguration());
                this.tempQPath = new Path(new Path(taskTmpDir), "q-temp.seq");
                this.tempQw = SequenceFile.createWriter((FileSystem)localFs, (Configuration)context.getConfiguration(), (Path)this.tempQPath, IntWritable.class, DenseBlockWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
                this.closeables.addFirst((Closeable)this.tempQw);
                this.closeables.addFirst(new IOUtils.DeleteFileOnClose(new File(this.tempQPath.toString())));
            }
            return this.tempQw;
        }
    }

    public static class QJobKeyWritable
    implements WritableComparable<QJobKeyWritable> {
        private int taskId;
        private int taskRowOrdinal;

        public void readFields(DataInput in) throws IOException {
            this.taskId = in.readInt();
            this.taskRowOrdinal = in.readInt();
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.taskId);
            out.writeInt(this.taskRowOrdinal);
        }

        public int compareTo(QJobKeyWritable o) {
            if (this.taskId < o.taskId) {
                return -1;
            }
            if (this.taskId > o.taskId) {
                return 1;
            }
            if (this.taskRowOrdinal < o.taskRowOrdinal) {
                return -1;
            }
            if (this.taskRowOrdinal > o.taskRowOrdinal) {
                return 1;
            }
            return 0;
        }
    }
}

