/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.util.Arrays;
import org.apache.mahout.math.Vector;

public class Omega {
    private static final double UNIFORM_DIVISOR = Math.pow(2.0, 64.0);
    private final long seed;
    private final int kp;

    public Omega(long seed, int k, int p) {
        this.seed = seed;
        this.kp = k + p;
    }

    public double getQuick(int row, int column) {
        long hash = Omega.murmur64((long)row << 32 | (long)column, 8, this.seed);
        double result = (double)hash / UNIFORM_DIVISOR;
        return result;
    }

    public void accumDots(int aIndex, double aElement, double[] yRow) {
        for (int i = 0; i < this.kp; ++i) {
            int n = i;
            yRow[n] = yRow[n] + this.getQuick(aIndex, i) * aElement;
        }
    }

    public void computeYRow(Vector aRow, double[] yRow) {
        Arrays.fill(yRow, 0.0);
        if (aRow.isDense()) {
            int n = aRow.size();
            for (int j = 0; j < n; ++j) {
                this.accumDots(j, aRow.getQuick(j), yRow);
            }
        } else {
            for (Vector.Element el : aRow) {
                this.accumDots(el.index(), el.get(), yRow);
            }
        }
    }

    public static long murmur64(long val, int len, long seed) {
        long m = -4132994306676758123L;
        long h = seed ^ (long)len * m;
        long k = val;
        k *= m;
        int r = 47;
        k ^= k >>> r;
        h ^= (k *= m);
        h *= m;
        h ^= h >>> r;
        h *= m;
        h ^= h >>> r;
        return h;
    }

    public static long murmur64(byte[] val, int offset, int len, long seed) {
        long m = -4132994306676758123L;
        int r = 47;
        long h = seed ^ (long)len * m;
        int lt = len >>> 3;
        int i = 0;
        while (i < lt) {
            long k = 0L;
            for (int j = 0; j < 8; ++j) {
                k <<= 8;
                k |= (long)(val[offset + j] & 0xFF);
            }
            k *= m;
            k ^= k >>> r;
            h ^= (k *= m);
            h *= m;
            ++i;
            offset += 8;
        }
        if (offset < len) {
            long k = 0L;
            while (offset < len) {
                k <<= 8;
                k |= (long)(val[offset] & 0xFF);
                ++offset;
            }
            h ^= k;
            h *= m;
        }
        h ^= h >>> r;
        h *= m;
        h ^= h >>> r;
        return h;
    }
}

