/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.stochasticsvd.UpperTriangular;

public class GivensThinSolver {
    private double[] vARow;
    private double[] vQtRow;
    private double[][] mQt;
    private double[][] mR;
    private int qtStartRow;
    private int rStartRow;
    private int m;
    private final int n;
    private int cnt;
    private final double[] cs = new double[2];

    public GivensThinSolver(int m, int n) {
        if (m < n) {
            throw new IllegalArgumentException("Givens thin QR: must be true: m>=n");
        }
        this.m = m;
        this.n = n;
        this.mQt = new double[n][];
        this.mR = new double[n][];
        this.vARow = new double[n];
        this.vQtRow = new double[m];
        for (int i = 0; i < n; ++i) {
            this.mQt[i] = new double[this.m];
            this.mR[i] = new double[this.n];
        }
        this.cnt = 0;
    }

    public void reset() {
        this.cnt = 0;
    }

    public void solve(Matrix a) {
        assert (a.rowSize() == this.m);
        assert (a.columnSize() == this.n);
        double[] aRow = new double[this.n];
        for (int i = 0; i < this.m; ++i) {
            Vector aRowV = a.getRow(i);
            for (int j = 0; j < this.n; ++j) {
                aRow[j] = aRowV.getQuick(j);
            }
            this.appendRow(aRow);
        }
    }

    public boolean isFull() {
        return this.cnt == this.m;
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getCnt() {
        return this.cnt;
    }

    public void adjust(int newM) {
        if (newM == this.m) {
            return;
        }
        if (newM < this.n) {
            throw new IllegalArgumentException("new m can't be less than n");
        }
        if (newM < this.cnt) {
            throw new IllegalArgumentException("new m can't be less than rows accumulated");
        }
        this.vQtRow = new double[newM];
        if (newM > this.m) {
            for (int i = 0; i < this.n; ++i) {
                this.mQt[i] = Arrays.copyOf(this.mQt[i], newM);
                System.arraycopy(this.mQt[i], 0, this.mQt[i], newM - this.m, this.m);
                Arrays.fill(this.mQt[i], 0, newM - this.m, 0.0);
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                this.mQt[i] = Arrays.copyOfRange(this.mQt[i], this.m - newM, this.m);
            }
        }
        this.m = newM;
    }

    public void trim() {
        this.adjust(this.cnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendRow(double[] aRow) {
        if (this.cnt >= this.m) {
            throw new IllegalStateException("thin QR solver fed more rows than initialized for");
        }
        try {
            Arrays.fill(this.vQtRow, 0.0);
            this.vQtRow[this.m - this.cnt - 1] = 1.0;
            int height = this.cnt > this.n ? this.n : this.cnt;
            System.arraycopy(aRow, 0, this.vARow, 0, this.n);
            if (height > 0) {
                GivensThinSolver.givens(this.vARow[0], this.getRRow(0)[0], this.cs);
                GivensThinSolver.applyGivensInPlace(this.cs[0], this.cs[1], this.vARow, this.getRRow(0), 0, this.n);
                GivensThinSolver.applyGivensInPlace(this.cs[0], this.cs[1], this.vQtRow, this.getQtRow(0), 0, this.m);
            }
            for (int i = 1; i < height; ++i) {
                GivensThinSolver.givens(this.getRRow(i - 1)[i], this.getRRow(i)[i], this.cs);
                GivensThinSolver.applyGivensInPlace(this.cs[0], this.cs[1], this.getRRow(i - 1), this.getRRow(i), i, this.n - i);
                GivensThinSolver.applyGivensInPlace(this.cs[0], this.cs[1], this.getQtRow(i - 1), this.getQtRow(i), 0, this.m);
            }
            this.pushQtDown();
            double[] swap = this.getQtRow(0);
            this.setQtRow(0, this.vQtRow);
            this.vQtRow = swap;
            this.pushRDown();
            swap = this.getRRow(0);
            this.setRRow(0, this.vARow);
            this.vARow = swap;
        }
        finally {
            ++this.cnt;
        }
    }

    private double[] getQtRow(int row) {
        return this.mQt[(row += this.qtStartRow) >= this.n ? row - this.n : row];
    }

    private void setQtRow(int row, double[] qtRow) {
        this.mQt[(row += this.qtStartRow) >= this.n ? row - this.n : row] = qtRow;
    }

    private void pushQtDown() {
        this.qtStartRow = this.qtStartRow == 0 ? this.n - 1 : this.qtStartRow - 1;
    }

    private double[] getRRow(int row) {
        return this.mR[(row += this.rStartRow) >= this.n ? row - this.n : row];
    }

    private void setRRow(int row, double[] rrow) {
        this.mR[(row += this.rStartRow) >= this.n ? row - this.n : row] = rrow;
    }

    private void pushRDown() {
        this.rStartRow = this.rStartRow == 0 ? this.n - 1 : this.rStartRow - 1;
    }

    public UpperTriangular getRTilde() {
        UpperTriangular packedR = new UpperTriangular(this.n);
        for (int i = 0; i < this.n; ++i) {
            packedR.assignRow(i, this.getRRow(i));
        }
        return packedR;
    }

    public double[][] getThinQtTilde() {
        if (this.qtStartRow != 0) {
            double[][] qt = new double[this.n][];
            System.arraycopy(this.mQt, this.qtStartRow, qt, 0, this.n - this.qtStartRow);
            System.arraycopy(this.mQt, 0, qt, this.n - this.qtStartRow, this.qtStartRow);
            return qt;
        }
        return this.mQt;
    }

    public static void applyGivensInPlace(double c, double s, double[] row1, double[] row2, int offset, int len) {
        int n = offset + len;
        for (int j = offset; j < n; ++j) {
            double tau1 = row1[j];
            double tau2 = row2[j];
            row1[j] = c * tau1 - s * tau2;
            row2[j] = s * tau1 + c * tau2;
        }
    }

    public static void applyGivensInPlace(double c, double s, Vector row1, Vector row2, int offset, int len) {
        int n = offset + len;
        for (int j = offset; j < n; ++j) {
            double tau1 = row1.getQuick(j);
            double tau2 = row2.getQuick(j);
            row1.setQuick(j, c * tau1 - s * tau2);
            row2.setQuick(j, s * tau1 + c * tau2);
        }
    }

    public static void applyGivensInPlace(double c, double s, int i, int k, Matrix mx) {
        int n = mx.columnSize();
        for (int j = 0; j < n; ++j) {
            double tau1 = mx.get(i, j);
            double tau2 = mx.get(k, j);
            mx.set(i, j, c * tau1 - s * tau2);
            mx.set(k, j, s * tau1 + c * tau2);
        }
    }

    public static void fromRho(double rho, double[] csOut) {
        if (rho == 1.0) {
            csOut[0] = 0.0;
            csOut[1] = 1.0;
            return;
        }
        if (Math.abs(rho) < 1.0) {
            csOut[1] = 2.0 * rho;
            csOut[0] = Math.sqrt(1.0 - csOut[1] * csOut[1]);
            return;
        }
        csOut[0] = 2.0 / rho;
        csOut[1] = Math.sqrt(1.0 - csOut[0] * csOut[0]);
    }

    public static void givens(double a, double b, double[] csOut) {
        if (b == 0.0) {
            csOut[0] = 1.0;
            csOut[1] = 0.0;
            return;
        }
        if (Math.abs(b) > Math.abs(a)) {
            double tau = -a / b;
            csOut[1] = 1.0 / Math.sqrt(1.0 + tau * tau);
            csOut[0] = csOut[1] * tau;
        } else {
            double tau = -b / a;
            csOut[0] = 1.0 / Math.sqrt(1.0 + tau * tau);
            csOut[1] = csOut[0] * tau;
        }
    }

    public static double toRho(double c, double s) {
        if (c == 0.0) {
            return 1.0;
        }
        if (Math.abs(s) < Math.abs(c)) {
            return Math.signum(c) * s / 2.0;
        }
        return Math.signum(s) * 2.0 / c;
    }

    public static void mergeR(UpperTriangular r1, UpperTriangular r2) {
        TriangularRowView r1Row = new TriangularRowView(r1);
        TriangularRowView r2Row = new TriangularRowView(r2);
        int kp = r1Row.size();
        assert (kp == r2Row.size());
        double[] cs = new double[2];
        for (int v = 0; v < kp; ++v) {
            for (int u = v; u < kp; ++u) {
                GivensThinSolver.givens(r1Row.setViewedRow(u).get(u), r2Row.setViewedRow(u - v).get(u), cs);
                GivensThinSolver.applyGivensInPlace(cs[0], cs[1], (Vector)r1Row, (Vector)r2Row, u, kp - u);
            }
        }
    }

    public static void mergeR(double[][] r1, double[][] r2) {
        int kp = r1[0].length;
        assert (kp == r2[0].length);
        double[] cs = new double[2];
        for (int v = 0; v < kp; ++v) {
            for (int u = v; u < kp; ++u) {
                GivensThinSolver.givens(r1[u][u], r2[u - v][u], cs);
                GivensThinSolver.applyGivensInPlace(cs[0], cs[1], r1[u], r2[u - v], u, kp - u);
            }
        }
    }

    public static void mergeRonQ(UpperTriangular r1, UpperTriangular r2, double[][] qt1, double[][] qt2) {
        TriangularRowView r1Row = new TriangularRowView(r1);
        TriangularRowView r2Row = new TriangularRowView(r2);
        int kp = r1Row.size();
        assert (kp == r2Row.size());
        assert (kp == qt1.length);
        assert (kp == qt2.length);
        int r = qt1[0].length;
        assert (qt2[0].length == r);
        double[] cs = new double[2];
        for (int v = 0; v < kp; ++v) {
            for (int u = v; u < kp; ++u) {
                GivensThinSolver.givens(r1Row.setViewedRow(u).get(u), r2Row.setViewedRow(u - v).get(u), cs);
                GivensThinSolver.applyGivensInPlace(cs[0], cs[1], (Vector)r1Row, (Vector)r2Row, u, kp - u);
                GivensThinSolver.applyGivensInPlace(cs[0], cs[1], qt1[u], qt2[u - v], 0, r);
            }
        }
    }

    public static void mergeRonQ(double[][] r1, double[][] r2, double[][] qt1, double[][] qt2) {
        int kp = r1[0].length;
        assert (kp == r2[0].length);
        assert (kp == qt1.length);
        assert (kp == qt2.length);
        int r = qt1[0].length;
        assert (qt2[0].length == r);
        double[] cs = new double[2];
        for (int v = 0; v < kp; ++v) {
            for (int u = v; u < kp; ++u) {
                GivensThinSolver.givens(r1[u][u], r2[u - v][u], cs);
                GivensThinSolver.applyGivensInPlace(cs[0], cs[1], r1[u], r2[u - v], u, kp - u);
                GivensThinSolver.applyGivensInPlace(cs[0], cs[1], qt1[u], qt2[u - v], 0, r);
            }
        }
    }

    public static double[][] mergeQrUp(double[][] qt1, double[][] r1, double[][] r2) {
        int kp = qt1.length;
        int r = qt1[0].length;
        double[][] qTilde = new double[kp][];
        for (int i = 0; i < kp; ++i) {
            qTilde[i] = new double[r];
        }
        GivensThinSolver.mergeRonQ(r1, r2, qt1, (double[][])qTilde);
        return qt1;
    }

    public static double[][] mergeQrUp(double[][] qt1, UpperTriangular r1, UpperTriangular r2) {
        int kp = qt1.length;
        int r = qt1[0].length;
        double[][] qTilde = new double[kp][];
        for (int i = 0; i < kp; ++i) {
            qTilde[i] = new double[r];
        }
        GivensThinSolver.mergeRonQ(r1, r2, qt1, (double[][])qTilde);
        return qt1;
    }

    public static double[][] mergeQrDown(double[][] r1, double[][] qt2, double[][] r2) {
        int kp = qt2.length;
        int r = qt2[0].length;
        double[][] qTilde = new double[kp][];
        for (int i = 0; i < kp; ++i) {
            qTilde[i] = new double[r];
        }
        GivensThinSolver.mergeRonQ(r1, r2, (double[][])qTilde, qt2);
        return qTilde;
    }

    public static double[][] mergeQrDown(UpperTriangular r1, double[][] qt2, UpperTriangular r2) {
        int kp = qt2.length;
        int r = qt2[0].length;
        double[][] qTilde = new double[kp][];
        for (int i = 0; i < kp; ++i) {
            qTilde[i] = new double[r];
        }
        GivensThinSolver.mergeRonQ(r1, r2, (double[][])qTilde, qt2);
        return qTilde;
    }

    public static double[][] computeQtHat(double[][] qt, int i, Iterator<UpperTriangular> rIter) {
        UpperTriangular rTilde = rIter.next();
        for (int j = 1; j < i; ++j) {
            GivensThinSolver.mergeR(rTilde, rIter.next());
        }
        if (i > 0) {
            qt = GivensThinSolver.mergeQrDown(rTilde, qt, rIter.next());
        }
        while (rIter.hasNext()) {
            qt = GivensThinSolver.mergeQrUp(qt, rTilde, rIter.next());
        }
        return qt;
    }

    public static boolean isOrthonormal(double[][] qt, boolean insufficientRank, double epsilon) {
        int n = qt.length;
        int rank = 0;
        for (int i = 0; i < n; ++i) {
            DenseVector ei = new DenseVector(qt[i], true);
            double norm = ei.norm(2.0);
            if (Math.abs(1.0 - norm) < epsilon) {
                ++rank;
            } else if (Math.abs(norm) > epsilon) {
                return false;
            }
            for (int j = 0; j <= i; ++j) {
                DenseVector ej;
                double dot;
                if (Math.abs((i == j && rank > j ? 1.0 : 0.0) - (dot = ei.dot((Vector)(ej = new DenseVector(qt[j], true))))) < epsilon) continue;
                return false;
            }
        }
        return insufficientRank ? rank < n : rank == n;
    }

    public static boolean isOrthonormalBlocked(Iterable<double[][]> qtHats, boolean insufficientRank, double epsilon) {
        int n = qtHats.iterator().next().length;
        int rank = 0;
        for (int i = 0; i < n; ++i) {
            ArrayList<DenseVector> ei = new ArrayList<DenseVector>();
            for (double[][] qtHat : qtHats) {
                ei.add(new DenseVector(qtHat[i], true));
            }
            double norm = 0.0;
            for (Vector vector : ei) {
                norm += vector.dot(vector);
            }
            if (Math.abs(1.0 - (norm = Math.sqrt(norm))) < epsilon) {
                ++rank;
            } else if (Math.abs(norm) > epsilon) {
                return false;
            }
            for (int j = 0; j <= i; ++j) {
                ArrayList<DenseVector> arrayList = new ArrayList<DenseVector>();
                for (double[][] qtHat : qtHats) {
                    arrayList.add(new DenseVector(qtHat[j], true));
                }
                double dot = 0.0;
                for (int k = 0; k < ei.size(); ++k) {
                    dot += ((Vector)ei.get(k)).dot((Vector)arrayList.get(k));
                }
                if (Math.abs((double)(i == j && rank > j ? 1 : 0) - dot) < epsilon) continue;
                return false;
            }
        }
        return insufficientRank ? rank < n : rank == n;
    }

    private static final class TriangularRowView
    extends AbstractVector {
        private final UpperTriangular viewed;
        private int rowNum;

        private TriangularRowView(UpperTriangular viewed) {
            super(viewed.columnSize());
            this.viewed = viewed;
        }

        TriangularRowView setViewedRow(int row) {
            this.rowNum = row;
            return this;
        }

        public boolean isDense() {
            return true;
        }

        public boolean isSequentialAccess() {
            return false;
        }

        public Iterator<Vector.Element> iterator() {
            throw new UnsupportedOperationException();
        }

        public Iterator<Vector.Element> iterateNonZero() {
            throw new UnsupportedOperationException();
        }

        public double getQuick(int index) {
            return this.viewed.getQuick(this.rowNum, index);
        }

        public Vector like() {
            throw new UnsupportedOperationException();
        }

        public void setQuick(int index, double value) {
            this.viewed.setQuick(this.rowNum, index, value);
        }

        public int getNumNondefaultElements() {
            throw new UnsupportedOperationException();
        }

        public Matrix matrixLike(int rows, int columns) {
            throw new UnsupportedOperationException();
        }
    }
}

