/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.MultipleOutputs;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.iterator.CopyConstructorIterator;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.DenseBlockWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.GivensThinSolver;
import org.apache.mahout.math.hadoop.stochasticsvd.QJob;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDSolver;
import org.apache.mahout.math.hadoop.stochasticsvd.UpperTriangular;

public final class BtJob {
    public static final String OUTPUT_Q = "Q";
    public static final String OUTPUT_BT = "part";
    public static final String PROP_QJOB_PATH = "ssvd.QJob.path";

    private BtJob() {
    }

    public static void run(Configuration conf, Path[] inputPathA, Path inputPathQJob, Path outputPath, int minSplitSize, int k, int p, int numReduceTasks, Class<? extends Writable> labelClass) throws ClassNotFoundException, InterruptedException, IOException {
        JobConf oldApiJob = new JobConf(conf);
        MultipleOutputs.addNamedOutput((JobConf)oldApiJob, (String)OUTPUT_Q, org.apache.hadoop.mapred.SequenceFileOutputFormat.class, labelClass, VectorWritable.class);
        Job job = new Job((Configuration)oldApiJob);
        job.setJobName("Bt-job");
        job.setJarByClass(BtJob.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])inputPathA);
        if (minSplitSize > 0) {
            FileInputFormat.setMinInputSplitSize((Job)job, (long)minSplitSize);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.getConfiguration().set("mapreduce.output.basename", OUTPUT_BT);
        FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        FileOutputFormat.setOutputCompressorClass((Job)job, DefaultCodec.class);
        SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(VectorWritable.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setMapperClass(BtMapper.class);
        job.setCombinerClass(OuterProductReducer.class);
        job.setReducerClass(OuterProductReducer.class);
        job.getConfiguration().setInt("ssvd.k", k);
        job.getConfiguration().setInt("ssvd.p", p);
        job.getConfiguration().set(PROP_QJOB_PATH, inputPathQJob.toString());
        job.setNumReduceTasks(numReduceTasks);
        job.submit();
        job.waitForCompletion(false);
        if (!job.isSuccessful()) {
            throw new IOException("Bt job unsuccessful.");
        }
    }

    public static class OuterProductReducer
    extends Reducer<IntWritable, VectorWritable, IntWritable, VectorWritable> {
        private final VectorWritable oValue = new VectorWritable();
        private DenseVector accum;

        protected void reduce(IntWritable key, Iterable<VectorWritable> values, Reducer.Context ctx) throws IOException, InterruptedException {
            Iterator<VectorWritable> vwIter = values.iterator();
            Vector vec = vwIter.next().get();
            if (this.accum == null || this.accum.size() != vec.size()) {
                this.accum = new DenseVector(vec);
                this.oValue.set((Vector)this.accum);
            } else {
                this.accum.assign(vec);
            }
            while (vwIter.hasNext()) {
                this.accum.addAll(vwIter.next().get());
            }
            ctx.write((Object)key, (Object)this.oValue);
        }
    }

    public static class BtMapper
    extends Mapper<Writable, VectorWritable, IntWritable, VectorWritable> {
        private SequenceFile.Reader qInput;
        private final List<UpperTriangular> mRs = new ArrayList<UpperTriangular>();
        private int blockNum;
        private double[][] mQt;
        private int cnt;
        private int r;
        private MultipleOutputs outputs;
        private final IntWritable btKey = new IntWritable();
        private final VectorWritable btValue = new VectorWritable();
        private int kp;
        private final VectorWritable qRowValue = new VectorWritable();

        void loadNextQt() throws IOException {
            QJob.QJobKeyWritable key = new QJob.QJobKeyWritable();
            DenseBlockWritable v = new DenseBlockWritable();
            boolean more = this.qInput.next((Writable)key, (Writable)v);
            assert (more);
            this.mQt = GivensThinSolver.computeQtHat(v.getBlock(), this.blockNum == 0 ? 0 : 1, new CopyConstructorIterator<UpperTriangular>(this.mRs.iterator()));
            this.r = this.mQt[0].length;
            this.kp = this.mQt.length;
            if (this.btValue.get() == null) {
                this.btValue.set((Vector)new DenseVector(this.kp));
            }
            if (this.qRowValue.get() == null) {
                this.qRowValue.set((Vector)new DenseVector(this.kp));
            }
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (this.qInput != null) {
                this.qInput.close();
            }
            if (this.outputs != null) {
                this.outputs.close();
            }
            super.cleanup(context);
        }

        private void outputQRow(Writable key, Writable value) throws IOException {
            this.outputs.getCollector(BtJob.OUTPUT_Q, null).collect((Object)key, (Object)value);
        }

        protected void map(Writable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.mQt != null && this.cnt++ == this.r) {
                this.mQt = null;
            }
            if (this.mQt == null) {
                this.loadNextQt();
                this.cnt = 1;
            }
            Vector aRow = value.get();
            int qRowIndex = this.r - this.cnt;
            Vector qRow = this.qRowValue.get();
            for (int j = 0; j < this.kp; ++j) {
                qRow.setQuick(j, this.mQt[j][qRowIndex]);
            }
            this.outputQRow(key, this.qRowValue);
            Vector btRow = this.btValue.get();
            if (!aRow.isDense()) {
                for (Vector.Element el : aRow) {
                    double mul = el.get();
                    for (int j = 0; j < this.kp; ++j) {
                        btRow.setQuick(j, mul * qRow.getQuick(j));
                    }
                    this.btKey.set(el.index());
                    context.write((Object)this.btKey, (Object)this.btValue);
                }
            } else {
                int n = aRow.size();
                for (int i = 0; i < n; ++i) {
                    double mul = aRow.getQuick(i);
                    for (int j = 0; j < this.kp; ++j) {
                        btRow.setQuick(j, mul * qRow.getQuick(j));
                    }
                    this.btKey.set(i);
                    context.write((Object)this.btKey, (Object)this.btValue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Path qJobPath = new Path(context.getConfiguration().get(BtJob.PROP_QJOB_PATH));
            FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
            Path qInputPath = new Path(qJobPath, FileOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)"QHat", (String)""));
            this.qInput = new SequenceFile.Reader(fs, qInputPath, context.getConfiguration());
            this.blockNum = context.getTaskAttemptID().getTaskID().getId();
            Path rPath = new Path(qJobPath, "R-*");
            FileStatus[] rFiles = fs.globStatus(rPath);
            if (rFiles == null) {
                throw new IOException("Can't find R inputs ");
            }
            Arrays.sort(rFiles, SSVDSolver.PARTITION_COMPARATOR);
            int block = 0;
            for (FileStatus fstat : rFiles) {
                VectorWritable rValue;
                SequenceFileValueIterator iterator = new SequenceFileValueIterator(fstat.getPath(), true, context.getConfiguration());
                try {
                    rValue = (VectorWritable)((Object)iterator.next());
                }
                finally {
                    iterator.close();
                }
                if (block < this.blockNum && block > 0) {
                    GivensThinSolver.mergeR(this.mRs.get(0), new UpperTriangular(rValue.get()));
                } else {
                    this.mRs.add(new UpperTriangular(rValue.get()));
                }
                ++block;
            }
            this.outputs = new MultipleOutputs(new JobConf(context.getConfiguration()));
        }
    }
}

