/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.UpperTriangular;

public final class BBtJob {
    public static final String OUTPUT_BBT = "part";

    private BBtJob() {
    }

    public static void run(Configuration conf, Path btPath, Path outputPath, int numReduceTasks) throws IOException, ClassNotFoundException, InterruptedException {
        Job job = new Job(conf);
        job.setJobName("BBt-job");
        job.setJarByClass(BBtJob.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{btPath});
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(VectorWritable.class);
        job.setMapperClass(BBtMapper.class);
        job.setReducerClass(BBtReducer.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        FileOutputFormat.setOutputCompressorClass((Job)job, DefaultCodec.class);
        job.getConfiguration().set("mapreduce.output.basename", OUTPUT_BBT);
        job.submit();
        job.waitForCompletion(false);
        if (!job.isSuccessful()) {
            throw new IOException("BBt job failed.");
        }
    }

    public static class BBtReducer
    extends Reducer<IntWritable, VectorWritable, IntWritable, VectorWritable> {
        private double[] accum;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            try {
                if (this.accum != null) {
                    context.write((Object)new IntWritable(), (Object)new VectorWritable((Vector)new DenseVector(this.accum, true)));
                }
            }
            finally {
                super.cleanup(context);
            }
        }

        protected void reduce(IntWritable iw, Iterable<VectorWritable> ivw, Reducer.Context ctx) throws IOException, InterruptedException {
            Iterator<VectorWritable> vwIter = ivw.iterator();
            Vector bbtPartial = vwIter.next().get();
            if (this.accum == null) {
                this.accum = new double[bbtPartial.size()];
            }
            do {
                for (int i = 0; i < this.accum.length; ++i) {
                    int n = i;
                    this.accum[n] = this.accum[n] + bbtPartial.getQuick(i);
                }
            } while (vwIter.hasNext() && (bbtPartial = vwIter.next().get()) != null);
        }
    }

    public static class BBtMapper
    extends Mapper<IntWritable, VectorWritable, IntWritable, VectorWritable> {
        private final VectorWritable vw = new VectorWritable();
        private final IntWritable iw = new IntWritable();
        private UpperTriangular bbtPartial;

        protected void map(IntWritable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            Vector btVec = value.get();
            int kp = btVec.size();
            if (this.bbtPartial == null) {
                this.bbtPartial = new UpperTriangular(kp);
            }
            for (int i = 0; i < kp; ++i) {
                double mul = btVec.getQuick(i);
                for (int j = i; j < kp; ++j) {
                    this.bbtPartial.setQuick(i, j, this.bbtPartial.getQuick(i, j) + mul * btVec.getQuick(j));
                }
            }
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (this.bbtPartial != null) {
                this.iw.set(context.getTaskAttemptID().getTaskID().getId());
                this.vw.set((Vector)new DenseVector(this.bbtPartial.getData(), true));
                context.write((Object)this.iw, (Object)this.vw);
            }
            super.cleanup(context);
        }
    }
}

