/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.vector;

import java.util.Iterator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.similarity.Cooccurrence;
import org.apache.mahout.math.hadoop.similarity.vector.AbstractDistributedVectorSimilarity;

public class DistributedUncenteredZeroAssumingCosineVectorSimilarity
extends AbstractDistributedVectorSimilarity {
    @Override
    protected double doComputeResult(int rowA, int rowB, Iterable<Cooccurrence> cooccurrences, double weightOfVectorA, double weightOfVectorB, int numberOfColumns) {
        double sumXY = 0.0;
        for (Cooccurrence cooccurrence : cooccurrences) {
            sumXY += cooccurrence.getValueA() * cooccurrence.getValueB();
        }
        if (sumXY == 0.0) {
            return Double.NaN;
        }
        return sumXY / (weightOfVectorA * weightOfVectorB);
    }

    @Override
    public double weight(Vector v) {
        double length = 0.0;
        Iterator elemIterator = v.iterateNonZero();
        while (elemIterator.hasNext()) {
            double value = ((Vector.Element)elemIterator.next()).get();
            length += value * value;
        }
        return Math.sqrt(length);
    }
}

