/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.vector;

import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.similarity.Cooccurrence;
import org.apache.mahout.math.hadoop.similarity.vector.AbstractDistributedVectorSimilarity;

public class DistributedTanimotoCoefficientVectorSimilarity
extends AbstractDistributedVectorSimilarity {
    @Override
    protected double doComputeResult(int rowA, int rowB, Iterable<Cooccurrence> cooccurrences, double weightOfVectorA, double weightOfVectorB, int numberOfColumns) {
        double cooccurrenceCount = DistributedTanimotoCoefficientVectorSimilarity.countElements(cooccurrences);
        if (cooccurrenceCount == 0.0) {
            return Double.NaN;
        }
        return cooccurrenceCount / (weightOfVectorA + weightOfVectorB - cooccurrenceCount);
    }

    @Override
    public double weight(Vector v) {
        return DistributedTanimotoCoefficientVectorSimilarity.countElements(v.iterateNonZero());
    }
}

