/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.vector;

import org.apache.mahout.math.hadoop.similarity.Cooccurrence;
import org.apache.mahout.math.hadoop.similarity.vector.AbstractDistributedVectorSimilarity;

public class DistributedPearsonCorrelationVectorSimilarity
extends AbstractDistributedVectorSimilarity {
    @Override
    protected double doComputeResult(int rowA, int rowB, Iterable<Cooccurrence> cooccurrences, double weightOfVectorA, double weightOfVectorB, int numberOfColumns) {
        int count = 0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumX2 = 0.0;
        double sumY2 = 0.0;
        for (Cooccurrence cooccurrence : cooccurrences) {
            double x = cooccurrence.getValueA();
            double y = cooccurrence.getValueB();
            sumXY += x * y;
            sumX += x;
            sumX2 += x * x;
            sumY += y;
            sumY2 += y * y;
            ++count;
        }
        if (sumXY == 0.0) {
            return Double.NaN;
        }
        double n = count;
        double meanX = sumX / n;
        double meanY = sumY / n;
        double centeredSumXY = sumXY - meanY * sumX;
        double centeredSumX2 = sumX2 - meanX * sumX;
        double centeredSumY2 = sumY2 - meanY * sumY;
        double denominator = Math.sqrt(centeredSumX2) * Math.sqrt(centeredSumY2);
        if (denominator == 0.0) {
            return Double.NaN;
        }
        return centeredSumXY / denominator;
    }
}

