/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.vector;

import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.similarity.Cooccurrence;
import org.apache.mahout.math.hadoop.similarity.vector.AbstractDistributedVectorSimilarity;
import org.apache.mahout.math.stats.LogLikelihood;

public class DistributedLoglikelihoodVectorSimilarity
extends AbstractDistributedVectorSimilarity {
    @Override
    protected double doComputeResult(int rowA, int rowB, Iterable<Cooccurrence> cooccurrences, double weightOfVectorA, double weightOfVectorB, int numberOfColumns) {
        int cooccurrenceCount = DistributedLoglikelihoodVectorSimilarity.countElements(cooccurrences);
        if (cooccurrenceCount == 0) {
            return Double.NaN;
        }
        int occurrencesA = (int)weightOfVectorA;
        int occurrencesB = (int)weightOfVectorB;
        double logLikelihood = LogLikelihood.logLikelihoodRatio((int)cooccurrenceCount, (int)(occurrencesB - cooccurrenceCount), (int)(occurrencesA - cooccurrenceCount), (int)(numberOfColumns - occurrencesA - occurrencesB + cooccurrenceCount));
        return 1.0 - 1.0 / (1.0 + logLikelihood);
    }

    @Override
    public double weight(Vector v) {
        return DistributedLoglikelihoodVectorSimilarity.countElements(v.iterateNonZero());
    }
}

