/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.vector;

import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.similarity.Cooccurrence;
import org.apache.mahout.math.hadoop.similarity.vector.AbstractDistributedVectorSimilarity;

public final class DistributedCityBlockVectorSimilarity
extends AbstractDistributedVectorSimilarity {
    @Override
    protected double doComputeResult(int rowA, int rowB, Iterable<Cooccurrence> cooccurrences, double weightOfVectorA, double weightOfVectorB, int numberOfColumns) {
        int cooccurrenceCount = DistributedCityBlockVectorSimilarity.countElements(cooccurrences);
        if (cooccurrenceCount == 0) {
            return Double.NaN;
        }
        double distance = weightOfVectorA + weightOfVectorB - (double)(2 * cooccurrenceCount);
        return 1.0 / (1.0 + distance);
    }

    @Override
    public double weight(Vector v) {
        return DistributedCityBlockVectorSimilarity.countElements(v.iterateNonZero());
    }
}

