/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.mahout.math.Varint;

public class WeightedRowPair
implements WritableComparable<WeightedRowPair> {
    private int rowA;
    private int rowB;
    private double weightA;
    private double weightB;

    public WeightedRowPair() {
    }

    public WeightedRowPair(int rowA, int rowB, double weightA, double weightB) {
        this.rowA = rowA;
        this.rowB = rowB;
        this.weightA = weightA;
        this.weightB = weightB;
    }

    public void set(int rowA, int rowB, double weightA, double weightB) {
        this.rowA = rowA;
        this.rowB = rowB;
        this.weightA = weightA;
        this.weightB = weightB;
    }

    public int getRowA() {
        return this.rowA;
    }

    public int getRowB() {
        return this.rowB;
    }

    public double getWeightA() {
        return this.weightA;
    }

    public double getWeightB() {
        return this.weightB;
    }

    public void readFields(DataInput in) throws IOException {
        this.rowA = Varint.readSignedVarInt(in);
        this.rowB = Varint.readSignedVarInt(in);
        this.weightA = in.readDouble();
        this.weightB = in.readDouble();
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeSignedVarInt(this.rowA, out);
        Varint.writeSignedVarInt(this.rowB, out);
        out.writeDouble(this.weightA);
        out.writeDouble(this.weightB);
    }

    public int compareTo(WeightedRowPair other) {
        int result = WeightedRowPair.compare(this.rowA, other.rowA);
        if (result == 0) {
            result = WeightedRowPair.compare(this.rowB, other.rowB);
        }
        return result;
    }

    public int hashCode() {
        return this.rowA + 31 * this.rowB;
    }

    public boolean equals(Object other) {
        if (other instanceof WeightedRowPair) {
            WeightedRowPair otherPair = (WeightedRowPair)other;
            return this.rowA == otherPair.rowA && this.rowB == otherPair.rowB;
        }
        return false;
    }

    protected static int compare(int a, int b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }
}

