/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.Varint;

class WeightedOccurrence
implements Writable,
Cloneable {
    private int row;
    private double value;
    private double weight;

    WeightedOccurrence() {
    }

    WeightedOccurrence(int row, double value, double weight) {
        this.row = row;
        this.value = value;
        this.weight = weight;
    }

    public int getRow() {
        return this.row;
    }

    public double getValue() {
        return this.value;
    }

    public double getWeight() {
        return this.weight;
    }

    public WeightedOccurrence clone() {
        return new WeightedOccurrence(this.row, this.value, this.weight);
    }

    public void readFields(DataInput in) throws IOException {
        this.row = Varint.readSignedVarInt(in);
        this.value = in.readDouble();
        this.weight = in.readDouble();
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeSignedVarInt(this.row, out);
        out.writeDouble(this.value);
        out.writeDouble(this.weight);
    }

    public int hashCode() {
        return this.row;
    }

    public boolean equals(Object other) {
        return other instanceof WeightedOccurrence && this.row == ((WeightedOccurrence)other).row;
    }
}

