/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity;

import java.util.Arrays;
import org.apache.mahout.math.hadoop.similarity.vector.DistributedCityBlockVectorSimilarity;
import org.apache.mahout.math.hadoop.similarity.vector.DistributedCooccurrenceVectorSimilarity;
import org.apache.mahout.math.hadoop.similarity.vector.DistributedEuclideanDistanceVectorSimilarity;
import org.apache.mahout.math.hadoop.similarity.vector.DistributedLoglikelihoodVectorSimilarity;
import org.apache.mahout.math.hadoop.similarity.vector.DistributedPearsonCorrelationVectorSimilarity;
import org.apache.mahout.math.hadoop.similarity.vector.DistributedTanimotoCoefficientVectorSimilarity;
import org.apache.mahout.math.hadoop.similarity.vector.DistributedUncenteredCosineVectorSimilarity;
import org.apache.mahout.math.hadoop.similarity.vector.DistributedUncenteredZeroAssumingCosineVectorSimilarity;
import org.apache.mahout.math.hadoop.similarity.vector.DistributedVectorSimilarity;

public enum SimilarityType {
    SIMILARITY_COOCCURRENCE(DistributedCooccurrenceVectorSimilarity.class),
    SIMILARITY_EUCLIDEAN_DISTANCE(DistributedEuclideanDistanceVectorSimilarity.class),
    SIMILARITY_LOGLIKELIHOOD(DistributedLoglikelihoodVectorSimilarity.class),
    SIMILARITY_PEARSON_CORRELATION(DistributedPearsonCorrelationVectorSimilarity.class),
    SIMILARITY_TANIMOTO_COEFFICIENT(DistributedTanimotoCoefficientVectorSimilarity.class),
    SIMILARITY_UNCENTERED_COSINE(DistributedUncenteredCosineVectorSimilarity.class),
    SIMILARITY_UNCENTERED_ZERO_ASSUMING_COSINE(DistributedUncenteredZeroAssumingCosineVectorSimilarity.class),
    SIMILARITY_CITY_BLOCK(DistributedCityBlockVectorSimilarity.class);

    private final Class<? extends DistributedVectorSimilarity> similarityImplementation;

    private SimilarityType(Class<? extends DistributedVectorSimilarity> similarityImplementation) {
        this.similarityImplementation = similarityImplementation;
    }

    public String getSimilarityImplementationClassName() {
        return this.similarityImplementation.getName();
    }

    public static String listEnumNames() {
        return Arrays.toString((Object[])SimilarityType.values());
    }
}

