/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.mahout.math.Varint;

public class SimilarityMatrixEntryKey
implements WritableComparable<SimilarityMatrixEntryKey> {
    private int row;
    private double value;

    public SimilarityMatrixEntryKey() {
    }

    public SimilarityMatrixEntryKey(int row, double value) {
        this.row = row;
        this.value = value;
    }

    public void set(int row, double value) {
        this.row = row;
        this.value = value;
    }

    public int getRow() {
        return this.row;
    }

    public void readFields(DataInput in) throws IOException {
        this.row = Varint.readSignedVarInt(in);
        this.value = in.readDouble();
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeSignedVarInt(this.row, out);
        out.writeDouble(this.value);
    }

    public int compareTo(SimilarityMatrixEntryKey other) {
        return this.row == other.row ? 0 : (this.row < other.row ? -1 : 1);
    }

    public int hashCode() {
        return this.row;
    }

    public boolean equals(Object other) {
        return other instanceof SimilarityMatrixEntryKey && this.row == ((SimilarityMatrixEntryKey)other).row;
    }

    static {
        WritableComparator.define(SimilarityMatrixEntryKey.class, (WritableComparator)new SimilarityMatrixEntryKeyComparator());
    }

    public static class SimilarityMatrixEntryKeyGroupingComparator
    extends WritableComparator
    implements Serializable {
        protected SimilarityMatrixEntryKeyGroupingComparator() {
            super(SimilarityMatrixEntryKey.class, true);
        }

        public int compare(WritableComparable a, WritableComparable b) {
            return a.compareTo((Object)b);
        }
    }

    public static class SimilarityMatrixEntryKeyComparator
    extends WritableComparator
    implements Serializable {
        protected SimilarityMatrixEntryKeyComparator() {
            super(SimilarityMatrixEntryKey.class, true);
        }

        public int compare(WritableComparable a, WritableComparable b) {
            SimilarityMatrixEntryKey key1 = (SimilarityMatrixEntryKey)a;
            SimilarityMatrixEntryKey key2 = (SimilarityMatrixEntryKey)b;
            int result = SimilarityMatrixEntryKeyComparator.compare(key1.row, key2.row);
            if (result == 0) {
                result = -1 * SimilarityMatrixEntryKeyComparator.compare(key1.value, key2.value);
            }
            return result;
        }

        protected static int compare(long a, long b) {
            return a == b ? 0 : (a < b ? -1 : 1);
        }

        protected static int compare(double a, double b) {
            return a == b ? 0 : (a < b ? -1 : 1);
        }
    }
}

