/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.decomposer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.OrthonormalityVerifier;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.decomposer.EigenStatus;
import org.apache.mahout.math.decomposer.SimpleEigenVerifier;
import org.apache.mahout.math.decomposer.SingularVectorVerifier;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.hadoop.decomposer.EigenVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EigenVerificationJob
extends AbstractJob {
    public static final String CLEAN_EIGENVECTORS = "cleanEigenvectors";
    private static final Logger log = LoggerFactory.getLogger(EigenVerificationJob.class);
    private SingularVectorVerifier eigenVerifier;
    private VectorIterable eigensToVerify;
    private VectorIterable corpus;
    private double maxError;
    private double minEigenValue;
    private Path tmpOut;
    private Path outPath;
    private int maxEigensToKeep;
    private Path cleanedEigensPath;

    public void setEigensToVerify(VectorIterable eigens) {
        this.eigensToVerify = eigens;
    }

    public int run(String[] args) throws Exception {
        Map<String, String> argMap = this.handleArgs(args);
        if (argMap == null) {
            return -1;
        }
        if (argMap.isEmpty()) {
            return 0;
        }
        this.runJob(this.getConf(), new Path(argMap.get("--eigenInput")), new Path(argMap.get("--corpusInput")), this.getOutputPath(), argMap.get("--inMemory") != null, Double.parseDouble(argMap.get("--maxError")), Double.parseDouble(argMap.get("--minEigenvalue")), Integer.parseInt(argMap.get("--maxEigens")));
        return 0;
    }

    public int run(Path corpusInput, Path eigenInput, Path output, Path tempOut, double maxError, double minEigenValue, boolean inMemory, Configuration conf) throws IOException {
        this.outPath = output;
        this.tmpOut = tempOut;
        this.maxError = maxError;
        this.minEigenValue = minEigenValue;
        if (eigenInput != null && this.eigensToVerify == null) {
            this.prepareEigens(conf, eigenInput, inMemory);
        }
        DistributedRowMatrix c = new DistributedRowMatrix(corpusInput, tempOut, 1, 1);
        c.setConf(conf);
        this.corpus = c;
        this.eigenVerifier = new SimpleEigenVerifier();
        Map<MatrixSlice, EigenStatus> eigenMetaData = this.verifyEigens();
        List<Map.Entry<MatrixSlice, EigenStatus>> prunedEigenMeta = this.pruneEigens(eigenMetaData);
        this.saveCleanEigens(new Configuration(), prunedEigenMeta);
        return 0;
    }

    private Map<String, String> handleArgs(String[] args) {
        this.addOutputOption();
        this.addOption("eigenInput", "ei", "The Path for purported eigenVector input files (SequenceFile<WritableComparable,VectorWritable>.", null);
        this.addOption("corpusInput", "ci", "The Path for corpus input files (SequenceFile<WritableComparable,VectorWritable>.");
        this.addOption((Option)DefaultOptionCreator.outputOption().create());
        this.addOption(DefaultOptionCreator.helpOption());
        this.addOption("inMemory", "mem", "Buffer eigen matrix into memory (if you have enough!)", "false");
        this.addOption("maxError", "err", "Maximum acceptable error", "0.05");
        this.addOption("minEigenvalue", "mev", "Minimum eigenvalue to keep the vector for", "0.0");
        this.addOption("maxEigens", "max", "Maximum number of eigenvectors to keep (0 means all)", "0");
        return this.parseArguments(args);
    }

    private VectorIterable computePairwiseInnerProducts() {
        return OrthonormalityVerifier.pairwiseInnerProducts((Iterable)this.eigensToVerify);
    }

    private void saveCleanEigens(Configuration conf, Collection<Map.Entry<MatrixSlice, EigenStatus>> prunedEigenMeta) throws IOException {
        Path path = new Path(this.outPath, CLEAN_EIGENVECTORS);
        FileSystem fs = FileSystem.get((Configuration)conf);
        SequenceFile.Writer seqWriter = new SequenceFile.Writer(fs, conf, path, IntWritable.class, VectorWritable.class);
        IntWritable iw = new IntWritable();
        int numEigensWritten = 0;
        for (Map.Entry<MatrixSlice, EigenStatus> pruneSlice : prunedEigenMeta) {
            MatrixSlice s = pruneSlice.getKey();
            EigenStatus meta = pruneSlice.getValue();
            EigenVector ev = new EigenVector(s.vector(), meta.getEigenValue(), Math.abs(1.0 - meta.getCosAngle()), s.index());
            log.info("appending {} to {}", (Object)ev, (Object)path);
            VectorWritable vw = new VectorWritable((Vector)ev);
            iw.set(s.index());
            seqWriter.append((Writable)iw, (Writable)vw);
            if (++numEigensWritten != this.maxEigensToKeep) continue;
            log.info("{} of the {} total eigens have been written", (Object)this.maxEigensToKeep, (Object)prunedEigenMeta.size());
            break;
        }
        seqWriter.close();
        this.cleanedEigensPath = path;
    }

    private List<Map.Entry<MatrixSlice, EigenStatus>> pruneEigens(Map<MatrixSlice, EigenStatus> eigenMetaData) {
        ArrayList<Map.Entry<MatrixSlice, EigenStatus>> prunedEigenMeta = new ArrayList<Map.Entry<MatrixSlice, EigenStatus>>();
        for (Map.Entry<MatrixSlice, EigenStatus> entry : eigenMetaData.entrySet()) {
            if (!(Math.abs(1.0 - entry.getValue().getCosAngle()) < this.maxError) || !(entry.getValue().getEigenValue() > this.minEigenValue)) continue;
            prunedEigenMeta.add(entry);
        }
        Collections.sort(prunedEigenMeta, new Comparator<Map.Entry<MatrixSlice, EigenStatus>>(){

            @Override
            public int compare(Map.Entry<MatrixSlice, EigenStatus> e1, Map.Entry<MatrixSlice, EigenStatus> e2) {
                int index2;
                int index1 = e1.getKey().index();
                if (index1 < (index2 = e2.getKey().index())) {
                    return -1;
                }
                if (index1 > index2) {
                    return 1;
                }
                return 0;
            }
        });
        return prunedEigenMeta;
    }

    private Map<MatrixSlice, EigenStatus> verifyEigens() {
        HashMap<MatrixSlice, EigenStatus> eigenMetaData = new HashMap<MatrixSlice, EigenStatus>();
        for (MatrixSlice slice : this.eigensToVerify) {
            EigenStatus status = this.eigenVerifier.verify(this.corpus, slice.vector());
            eigenMetaData.put(slice, status);
        }
        return eigenMetaData;
    }

    private void prepareEigens(Configuration conf, Path eigenInput, boolean inMemory) {
        DistributedRowMatrix eigens = new DistributedRowMatrix(eigenInput, this.tmpOut, 1, 1);
        eigens.setConf(conf);
        if (inMemory) {
            ArrayList<Vector> eigenVectors = new ArrayList<Vector>();
            Iterator<MatrixSlice> i$ = eigens.iterator();
            while (i$.hasNext()) {
                MatrixSlice slice = i$.next();
                eigenVectors.add(slice.vector());
            }
            this.eigensToVerify = new SparseRowMatrix(new int[]{eigenVectors.size(), ((Vector)eigenVectors.get(0)).size()}, eigenVectors.toArray(new Vector[eigenVectors.size()]), true, true);
        } else {
            this.eigensToVerify = eigens;
        }
    }

    public Path getCleanedEigensPath() {
        return this.cleanedEigensPath;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new EigenVerificationJob(), (String[])args);
    }

    public void runJob(Configuration conf, Path eigenInput, Path corpusInput, Path output, boolean inMemory, double maxError, double minEigenValue, int maxEigens) throws IOException {
        this.outPath = output;
        this.tmpOut = new Path(this.outPath, "tmp");
        this.maxEigensToKeep = maxEigens;
        this.maxError = maxError;
        if (eigenInput != null && this.eigensToVerify == null) {
            this.prepareEigens(new Configuration(conf), eigenInput, inMemory);
        }
        DistributedRowMatrix c = new DistributedRowMatrix(corpusInput, this.tmpOut, 1, 1);
        c.setConf(new Configuration(conf));
        this.corpus = c;
        this.eigenVerifier = new SimpleEigenVerifier();
        Map<MatrixSlice, EigenStatus> eigenMetaData = this.verifyEigens();
        List<Map.Entry<MatrixSlice, EigenStatus>> prunedEigenMeta = this.pruneEigens(eigenMetaData);
        this.saveCleanEigens(conf, prunedEigenMeta);
    }
}

