/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;

public class TransposeJob
extends AbstractJob {
    public static final String NUM_ROWS_KEY = "SparseRowMatrix.numRows";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new TransposeJob(), (String[])args);
    }

    public int run(String[] strings) throws Exception {
        this.addInputOption();
        this.addOption("numRows", "nr", "Number of rows of the input matrix");
        this.addOption("numCols", "nc", "Number of columns of the input matrix");
        Map<String, String> parsedArgs = this.parseArguments(strings);
        if (parsedArgs == null) {
            return 0;
        }
        Path inputPath = this.getInputPath();
        Path outputTmpPath = new Path(parsedArgs.get("--tempDir"));
        int numRows = Integer.parseInt(parsedArgs.get("--numRows"));
        int numCols = Integer.parseInt(parsedArgs.get("--numCols"));
        DistributedRowMatrix matrix = new DistributedRowMatrix(inputPath, outputTmpPath, numRows, numCols);
        matrix.setConf(new Configuration(this.getConf()));
        matrix.transpose();
        return 0;
    }

    public static Configuration buildTransposeJobConf(Path matrixInputPath, Path matrixOutputPath, int numInputRows) throws IOException {
        return TransposeJob.buildTransposeJobConf(new Configuration(), matrixInputPath, matrixOutputPath, numInputRows);
    }

    public static Configuration buildTransposeJobConf(Configuration initialConf, Path matrixInputPath, Path matrixOutputPath, int numInputRows) throws IOException {
        JobConf conf = new JobConf(initialConf, TransposeJob.class);
        conf.setJobName("TransposeJob: " + matrixInputPath + " transpose -> " + matrixOutputPath);
        FileSystem fs = FileSystem.get((Configuration)conf);
        matrixInputPath = fs.makeQualified(matrixInputPath);
        matrixOutputPath = fs.makeQualified(matrixOutputPath);
        conf.setInt(NUM_ROWS_KEY, numInputRows);
        FileInputFormat.addInputPath((JobConf)conf, (Path)matrixInputPath);
        conf.setInputFormat(SequenceFileInputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)matrixOutputPath);
        conf.setMapperClass(TransposeMapper.class);
        conf.setReducerClass(TransposeReducer.class);
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(DistributedRowMatrix.MatrixEntryWritable.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(VectorWritable.class);
        return conf;
    }

    public static class TransposeReducer
    extends MapReduceBase
    implements Reducer<IntWritable, DistributedRowMatrix.MatrixEntryWritable, IntWritable, VectorWritable> {
        private int newNumCols;

        public void configure(JobConf conf) {
            this.newNumCols = conf.getInt(TransposeJob.NUM_ROWS_KEY, Integer.MAX_VALUE);
        }

        public void reduce(IntWritable outRow, Iterator<DistributedRowMatrix.MatrixEntryWritable> it, OutputCollector<IntWritable, VectorWritable> out, Reporter reporter) throws IOException {
            RandomAccessSparseVector tmp = new RandomAccessSparseVector(this.newNumCols, 100);
            while (it.hasNext()) {
                DistributedRowMatrix.MatrixEntryWritable e = it.next();
                tmp.setQuick(e.getCol(), e.getVal());
            }
            SequentialAccessSparseVector outVector = new SequentialAccessSparseVector((Vector)tmp);
            out.collect((Object)outRow, (Object)new VectorWritable((Vector)outVector));
        }
    }

    public static class TransposeMapper
    extends MapReduceBase
    implements Mapper<IntWritable, VectorWritable, IntWritable, DistributedRowMatrix.MatrixEntryWritable> {
        public void map(IntWritable r, VectorWritable v, OutputCollector<IntWritable, DistributedRowMatrix.MatrixEntryWritable> out, Reporter reporter) throws IOException {
            DistributedRowMatrix.MatrixEntryWritable entry = new DistributedRowMatrix.MatrixEntryWritable();
            Iterator it = v.get().iterateNonZero();
            int row = r.get();
            entry.setCol(row);
            entry.setRow(-1);
            while (it.hasNext()) {
                Vector.Element e = (Vector.Element)it.next();
                r.set(e.index());
                entry.setVal(e.get());
                out.collect((Object)r, (Object)entry);
            }
        }
    }
}

