/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class MatrixWritable
implements Writable {
    private Matrix matrix;
    private static final int NUM_FLAGS = 2;
    private static final int FLAG_DENSE = 1;
    private static final int FLAG_SEQUENTIAL = 2;

    public MatrixWritable() {
    }

    public MatrixWritable(Matrix m) {
        this.set(m);
    }

    public Matrix get() {
        return this.matrix;
    }

    public void set(Matrix matrix) {
        this.matrix = matrix;
    }

    public void write(DataOutput out) throws IOException {
        MatrixWritable.writeMatrix(out, this.matrix);
    }

    public void readFields(DataInput in) throws IOException {
        this.matrix = MatrixWritable.readMatrix(in);
    }

    public static void readLabels(DataInput in, Map<String, Integer> columnLabelBindings, Map<String, Integer> rowLabelBindings) throws IOException {
        int rowSize;
        int colSize = in.readInt();
        if (colSize > 0) {
            for (int i = 0; i < colSize; ++i) {
                columnLabelBindings.put(in.readUTF(), in.readInt());
            }
        }
        if ((rowSize = in.readInt()) > 0) {
            for (int i = 0; i < rowSize; ++i) {
                rowLabelBindings.put(in.readUTF(), in.readInt());
            }
        }
    }

    public static void writeLabelBindings(DataOutput out, Map<String, Integer> columnLabelBindings, Map<String, Integer> rowLabelBindings) throws IOException {
        if (columnLabelBindings == null) {
            out.writeInt(0);
        } else {
            out.writeInt(columnLabelBindings.size());
            for (Map.Entry<String, Integer> stringIntegerEntry : columnLabelBindings.entrySet()) {
                out.writeUTF(stringIntegerEntry.getKey());
                out.writeInt(stringIntegerEntry.getValue());
            }
        }
        if (rowLabelBindings == null) {
            out.writeInt(0);
        } else {
            out.writeInt(rowLabelBindings.size());
            for (Map.Entry<String, Integer> stringIntegerEntry : rowLabelBindings.entrySet()) {
                out.writeUTF(stringIntegerEntry.getKey());
                out.writeInt(stringIntegerEntry.getValue());
            }
        }
    }

    public static Matrix readMatrix(DataInput in) throws IOException {
        int flags = in.readInt();
        Preconditions.checkArgument((flags >> 2 == 0 ? 1 : 0) != 0, (String)"Unknown flags set: %d", (Object[])new Object[]{Integer.toString(flags, 2)});
        boolean dense = (flags & 1) != 0;
        boolean sequential = (flags & 2) != 0;
        int rows = in.readInt();
        int columns = in.readInt();
        Object r = dense ? new DenseMatrix(rows, columns) : new SparseRowMatrix(new int[]{rows, columns}, !sequential);
        for (int row = 0; row < rows; ++row) {
            r.viewRow(row).assign(VectorWritable.readVector(in));
        }
        return r;
    }

    public static void writeMatrix(DataOutput out, Matrix matrix) throws IOException {
        int flags = 0;
        Vector row = matrix.viewRow(0);
        if (row.isDense()) {
            flags |= 1;
        }
        if (row.isSequentialAccess()) {
            flags |= 2;
        }
        out.writeInt(flags);
        out.writeInt(matrix.rowSize());
        out.writeInt(matrix.columnSize());
        for (int i = 0; i < matrix.rowSize(); ++i) {
            VectorWritable.writeVector(out, matrix.viewRow(i), false);
        }
    }
}

