/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterable;

public final class OutputUtils {
    private OutputUtils() {
    }

    public static Path[] listOutputFiles(FileSystem fs, Path outpath) throws IOException {
        FileStatus[] status = fs.listStatus(outpath);
        ArrayList<Path> outpaths = new ArrayList<Path>();
        for (FileStatus s : status) {
            if (s.isDir()) continue;
            outpaths.add(s.getPath());
        }
        Path[] outfiles = new Path[outpaths.size()];
        outpaths.toArray(outfiles);
        return outfiles;
    }

    public static void importEvaluations(FileSystem fs, Configuration conf, Path outpath, Collection<Double> evaluations) throws IOException {
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, LongWritable.class, DoubleWritable.class, conf);
        Path[] outfiles = OutputUtils.listOutputFiles(fs, outpath);
        Path output = new Path(outpath, "output.sorted");
        sorter.merge(outfiles, output);
        for (DoubleWritable value : new SequenceFileValueIterable(output, true, conf)) {
            evaluations.add(value.get());
        }
    }
}

