/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.StringUtils;
import org.apache.mahout.ga.watchmaker.EvalMapper;
import org.apache.mahout.ga.watchmaker.OutputUtils;
import org.uncommons.watchmaker.framework.FitnessEvaluator;

public final class MahoutEvaluator {
    private MahoutEvaluator() {
    }

    public static void evaluate(FitnessEvaluator<?> evaluator, Iterable<?> population, Collection<Double> evaluations, Path input, Path output) throws IOException, ClassNotFoundException, InterruptedException {
        Job job = new Job();
        job.setJarByClass(MahoutEvaluator.class);
        Configuration conf = job.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        HadoopUtil.delete(conf, input);
        HadoopUtil.delete(conf, output);
        MahoutEvaluator.storePopulation(fs, new Path(input, "population"), population);
        MahoutEvaluator.configureJob(job, conf, evaluator, input, output);
        job.waitForCompletion(true);
        OutputUtils.importEvaluations(fs, conf, output, evaluations);
    }

    private static void configureJob(Job job, Configuration conf, FitnessEvaluator<?> evaluator, Path inpath, Path outpath) {
        conf.set("mapred.input.dir", inpath.toString());
        conf.set("mapred.output.dir", outpath.toString());
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(DoubleWritable.class);
        job.setMapperClass(EvalMapper.class);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        conf.set("mahout.ga.evaluator", StringUtils.toString(evaluator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storePopulation(FileSystem fs, Path f, Iterable<?> population) throws IOException {
        FSDataOutputStream out = fs.create(f);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out));
        try {
            for (Object candidate : population) {
                writer.write(StringUtils.toString(candidate));
                writer.newLine();
            }
        }
        finally {
            writer.close();
        }
    }
}

