/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.StringUtils;
import org.uncommons.watchmaker.framework.FitnessEvaluator;

public class EvalMapper
extends Mapper<LongWritable, Text, LongWritable, DoubleWritable> {
    public static final String MAHOUT_GA_EVALUATOR = "mahout.ga.evaluator";
    private FitnessEvaluator<Object> evaluator;

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String evlstr = conf.get(MAHOUT_GA_EVALUATOR);
        Preconditions.checkArgument((evlstr != null ? 1 : 0) != 0, (Object)"'MAHOUT_GA_EVALUATOR' job parameter not found");
        this.evaluator = (FitnessEvaluator)StringUtils.fromString(evlstr);
        super.setup(context);
    }

    public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        Object candidate = StringUtils.fromString(value.toString());
        double fitness = this.evaluator.getFitness(candidate, null);
        context.write((Object)key, (Object)new DoubleWritable(fitness));
    }
}

