/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.fpgrowth;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;

public class FPTree {
    public static final int ROOTNODEID = 0;
    private static final int DEFAULT_CHILDREN_INITIAL_SIZE = 2;
    private static final int DEFAULT_HEADER_TABLE_INITIAL_SIZE = 4;
    private static final int DEFAULT_INITIAL_SIZE = 8;
    private static final float GROWTH_RATE = 1.5f;
    private static final int HEADERTABLEBLOCKSIZE = 2;
    private static final int HT_LAST = 1;
    private static final int HT_NEXT = 0;
    private int[] attribute;
    private int[] childCount;
    private int[] conditional;
    private long[] headerTableAttributeCount;
    private int[] headerTableAttributes;
    private int headerTableCount;
    private int[] headerTableLookup;
    private int[][] headerTableProperties;
    private int[] next;
    private int[][] nodeChildren;
    private long[] nodeCount;
    private int nodes;
    private int[] parent;
    private boolean singlePath;
    private final Collection<Integer> sortedSet = new TreeSet<Integer>();

    public FPTree() {
        this(8);
    }

    public FPTree(int size) {
        if (size < 8) {
            size = 8;
        }
        this.parent = new int[size];
        this.next = new int[size];
        this.childCount = new int[size];
        this.attribute = new int[size];
        this.nodeCount = new long[size];
        this.nodeChildren = new int[size][];
        this.conditional = new int[size];
        this.headerTableAttributes = new int[4];
        this.headerTableAttributeCount = new long[4];
        this.headerTableLookup = new int[4];
        Arrays.fill(this.headerTableLookup, -1);
        this.headerTableProperties = new int[4][];
        this.singlePath = true;
        this.createRootNode();
    }

    public final void addChild(int parentNodeId, int childnodeId) {
        int length = this.childCount[parentNodeId];
        if (length >= this.nodeChildren[parentNodeId].length) {
            this.resizeChildren(parentNodeId);
        }
        this.nodeChildren[parentNodeId][length++] = childnodeId;
        this.childCount[parentNodeId] = length;
        if (length > 1 && this.singlePath) {
            this.singlePath = false;
        }
    }

    public final boolean addCount(int nodeId, long count) {
        if (nodeId < this.nodes) {
            int n = nodeId;
            this.nodeCount[n] = this.nodeCount[n] + count;
            return true;
        }
        return false;
    }

    public final void addHeaderCount(int attributeValue, long count) {
        int index;
        int n = index = this.getHeaderIndex(attributeValue);
        this.headerTableAttributeCount[n] = this.headerTableAttributeCount[n] + count;
    }

    public final void addHeaderNext(int attributeValue, int nodeId) {
        int index = this.getHeaderIndex(attributeValue);
        if (this.headerTableProperties[index][0] == -1) {
            this.headerTableProperties[index][0] = nodeId;
            this.headerTableProperties[index][1] = nodeId;
        } else {
            this.setNext(this.headerTableProperties[index][1], nodeId);
            this.headerTableProperties[index][1] = nodeId;
        }
    }

    public final int attribute(int nodeId) {
        return this.attribute[nodeId];
    }

    public final int childAtIndex(int nodeId, int index) {
        if (this.childCount[nodeId] < index) {
            return -1;
        }
        return this.nodeChildren[nodeId][index];
    }

    public final int childCount(int nodeId) {
        return this.childCount[nodeId];
    }

    public final int childWithAttribute(int nodeId, int childAttribute) {
        int length = this.childCount[nodeId];
        for (int i = 0; i < length; ++i) {
            if (this.attribute[this.nodeChildren[nodeId][i]] != childAttribute) continue;
            return this.nodeChildren[nodeId][i];
        }
        return -1;
    }

    public final void clear() {
        this.nodes = 0;
        this.headerTableCount = 0;
        this.singlePath = true;
        Arrays.fill(this.headerTableLookup, -1);
        this.sortedSet.clear();
        this.createRootNode();
    }

    public final void clearConditional() {
        for (int i = this.nodes - 1; i >= 0; --i) {
            this.conditional[i] = 0;
        }
    }

    public final int conditional(int nodeId) {
        return this.conditional[nodeId];
    }

    public final long count(int nodeId) {
        return this.nodeCount[nodeId];
    }

    public final int createConditionalNode(int attributeValue, long count) {
        if (this.nodes >= this.attribute.length) {
            this.resize();
        }
        this.childCount[this.nodes] = 0;
        this.next[this.nodes] = -1;
        this.parent[this.nodes] = -1;
        this.conditional[this.nodes] = 0;
        this.attribute[this.nodes] = attributeValue;
        this.nodeCount[this.nodes] = count;
        if (this.nodeChildren[this.nodes] == null) {
            this.nodeChildren[this.nodes] = new int[2];
        }
        return this.nodes++;
    }

    public final int createNode(int parentNodeId, int attributeValue, long count) {
        if (this.nodes >= this.attribute.length) {
            this.resize();
        }
        this.childCount[this.nodes] = 0;
        this.next[this.nodes] = -1;
        this.parent[this.nodes] = parentNodeId;
        this.attribute[this.nodes] = attributeValue;
        this.nodeCount[this.nodes] = count;
        this.conditional[this.nodes] = 0;
        if (this.nodeChildren[this.nodes] == null) {
            this.nodeChildren[this.nodes] = new int[2];
        }
        int childNodeId = this.nodes++;
        this.addChild(parentNodeId, childNodeId);
        this.addHeaderNext(attributeValue, childNodeId);
        return childNodeId;
    }

    public final int createRootNode() {
        this.childCount[this.nodes] = 0;
        this.next[this.nodes] = -1;
        this.parent[this.nodes] = 0;
        this.attribute[this.nodes] = -1;
        this.nodeCount[this.nodes] = 0L;
        if (this.nodeChildren[this.nodes] == null) {
            this.nodeChildren[this.nodes] = new int[2];
        }
        return this.nodes++;
    }

    public final int getAttributeAtIndex(int index) {
        return this.headerTableAttributes[index];
    }

    public final int getHeaderNext(int attributeValue) {
        int index = this.getHeaderIndex(attributeValue);
        return this.headerTableProperties[index][0];
    }

    public final long getHeaderSupportCount(int attributeValue) {
        int index = this.getHeaderIndex(attributeValue);
        return this.headerTableAttributeCount[index];
    }

    public final int[] getHeaderTableAttributes() {
        int[] attributes = new int[this.headerTableCount];
        System.arraycopy(this.headerTableAttributes, 0, attributes, 0, this.headerTableCount);
        return attributes;
    }

    public final int getHeaderTableCount() {
        return this.headerTableCount;
    }

    public final boolean isEmpty() {
        return this.nodes <= 1;
    }

    public final int next(int nodeId) {
        return this.next[nodeId];
    }

    public final int parent(int nodeId) {
        return this.parent[nodeId];
    }

    public final void removeHeaderNext(int attributeValue) {
        int index = this.getHeaderIndex(attributeValue);
        this.headerTableProperties[index][0] = -1;
    }

    public final void reorderHeaderTable() {
        int i = 0;
        for (int attr : this.sortedSet) {
            this.headerTableAttributes[i++] = attr;
        }
    }

    public void replaceChild(int parentNodeId, int replacableNode, int childnodeId) {
        int max = this.childCount[parentNodeId];
        for (int i = 0; i < max; ++i) {
            if (this.nodeChildren[parentNodeId][i] != replacableNode) continue;
            this.nodeChildren[parentNodeId][i] = childnodeId;
            this.parent[childnodeId] = parentNodeId;
        }
    }

    public final boolean setConditional(int nodeId, int conditionalNode) {
        if (nodeId < this.nodes) {
            this.conditional[nodeId] = conditionalNode;
            return true;
        }
        return false;
    }

    public final boolean setNext(int nodeId, int nextNode) {
        if (nodeId < this.nodes) {
            this.next[nodeId] = nextNode;
            return true;
        }
        return false;
    }

    public final boolean setParent(int nodeId, int parentNode) {
        if (nodeId < this.nodes) {
            this.parent[nodeId] = parentNode;
            int length = this.childCount[parentNode];
            if (length >= this.nodeChildren[parentNode].length) {
                this.resizeChildren(parentNode);
            }
            this.nodeChildren[parentNode][length++] = nodeId;
            this.childCount[parentNode] = length;
            return true;
        }
        return false;
    }

    public final void setSinglePath(boolean bit) {
        this.singlePath = bit;
    }

    public final boolean singlePath() {
        return this.singlePath;
    }

    private int getHeaderIndex(int attributeValue) {
        int index;
        if (attributeValue >= this.headerTableLookup.length) {
            this.resizeHeaderLookup(attributeValue);
        }
        if ((index = this.headerTableLookup[attributeValue]) == -1) {
            if (this.headerTableCount >= this.headerTableAttributes.length) {
                this.resizeHeaderTable();
            }
            this.headerTableAttributes[this.headerTableCount] = attributeValue;
            if (this.headerTableProperties[this.headerTableCount] == null) {
                this.headerTableProperties[this.headerTableCount] = new int[2];
            }
            this.headerTableAttributeCount[this.headerTableCount] = 0L;
            this.headerTableProperties[this.headerTableCount][0] = -1;
            this.headerTableProperties[this.headerTableCount][1] = -1;
            this.headerTableLookup[attributeValue] = index = this.headerTableCount++;
            this.sortedSet.add(attributeValue);
        }
        return index;
    }

    private void resize() {
        int size = (int)(1.5f * (float)this.nodes);
        if (size < 8) {
            size = 8;
        }
        int[] oldChildCount = this.childCount;
        int[] oldAttribute = this.attribute;
        long[] oldnodeCount = this.nodeCount;
        int[] oldParent = this.parent;
        int[] oldNext = this.next;
        int[][] oldNodeChildren = this.nodeChildren;
        int[] oldConditional = this.conditional;
        this.childCount = new int[size];
        this.attribute = new int[size];
        this.nodeCount = new long[size];
        this.parent = new int[size];
        this.next = new int[size];
        this.nodeChildren = new int[size][];
        this.conditional = new int[size];
        System.arraycopy(oldChildCount, 0, this.childCount, 0, this.nodes);
        System.arraycopy(oldAttribute, 0, this.attribute, 0, this.nodes);
        System.arraycopy(oldnodeCount, 0, this.nodeCount, 0, this.nodes);
        System.arraycopy(oldParent, 0, this.parent, 0, this.nodes);
        System.arraycopy(oldNext, 0, this.next, 0, this.nodes);
        System.arraycopy(oldNodeChildren, 0, this.nodeChildren, 0, this.nodes);
        System.arraycopy(oldConditional, 0, this.conditional, 0, this.nodes);
    }

    private void resizeChildren(int nodeId) {
        int length = this.childCount[nodeId];
        int size = (int)(1.5f * (float)length);
        if (size < 2) {
            size = 2;
        }
        int[] oldNodeChildren = this.nodeChildren[nodeId];
        this.nodeChildren[nodeId] = new int[size];
        System.arraycopy(oldNodeChildren, 0, this.nodeChildren[nodeId], 0, length);
    }

    private void resizeHeaderLookup(int attributeValue) {
        int size = (int)((float)attributeValue * 1.5f);
        int[] oldLookup = this.headerTableLookup;
        this.headerTableLookup = new int[size];
        Arrays.fill(this.headerTableLookup, oldLookup.length, size, -1);
        System.arraycopy(oldLookup, 0, this.headerTableLookup, 0, oldLookup.length);
    }

    private void resizeHeaderTable() {
        int size = (int)(1.5f * (float)this.headerTableCount);
        if (size < 4) {
            size = 4;
        }
        int[] oldAttributes = this.headerTableAttributes;
        long[] oldAttributeCount = this.headerTableAttributeCount;
        int[][] oldProperties = this.headerTableProperties;
        this.headerTableAttributes = new int[size];
        this.headerTableAttributeCount = new long[size];
        this.headerTableProperties = new int[size][];
        System.arraycopy(oldAttributes, 0, this.headerTableAttributes, 0, this.headerTableCount);
        System.arraycopy(oldAttributeCount, 0, this.headerTableAttributeCount, 0, this.headerTableCount);
        System.arraycopy(oldProperties, 0, this.headerTableProperties, 0, this.headerTableCount);
    }
}

