/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.fpgrowth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.fpm.pfpgrowth.CountDescendingPairComparator;
import org.apache.mahout.fpm.pfpgrowth.convertors.StatusUpdater;
import org.apache.mahout.fpm.pfpgrowth.convertors.TopKPatternsOutputConverter;
import org.apache.mahout.fpm.pfpgrowth.convertors.TransactionIterator;
import org.apache.mahout.fpm.pfpgrowth.convertors.string.TopKStringPatterns;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FPTree;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FPTreeDepthCache;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FrequentPatternMaxHeap;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.Pattern;
import org.apache.mahout.math.map.OpenIntIntHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FPGrowth<A extends Comparable<? super A>> {
    private static final Logger log = LoggerFactory.getLogger(FPGrowth.class);

    public static List<Pair<String, TopKStringPatterns>> readFrequentPattern(Configuration conf, Path path) {
        ArrayList<Pair<String, TopKStringPatterns>> ret = new ArrayList<Pair<String, TopKStringPatterns>>();
        for (Pair record : new SequenceFileIterable(path, true, conf)) {
            ret.add(new Pair<String, TopKStringPatterns>(((Writable)record.getFirst()).toString(), new TopKStringPatterns(((TopKStringPatterns)record.getSecond()).getPatterns())));
        }
        return ret;
    }

    public final List<Pair<A, Long>> generateFList(Iterator<Pair<List<A>, Long>> transactions, int minSupport) {
        HashMap<Comparable, MutableLong> attributeSupport = new HashMap<Comparable, MutableLong>();
        while (transactions.hasNext()) {
            Pair<List<A>, Long> transaction = transactions.next();
            for (Comparable attribute : transaction.getFirst()) {
                if (attributeSupport.containsKey(attribute)) {
                    ((MutableLong)attributeSupport.get(attribute)).add(transaction.getSecond().longValue());
                    continue;
                }
                attributeSupport.put(attribute, new MutableLong((Number)transaction.getSecond()));
            }
        }
        ArrayList<Pair<A, Long>> fList = new ArrayList<Pair<A, Long>>();
        for (Map.Entry e : attributeSupport.entrySet()) {
            long value = ((MutableLong)e.getValue()).longValue();
            if (value < (long)minSupport) continue;
            fList.add(new Pair(e.getKey(), value));
        }
        Collections.sort(fList, new CountDescendingPairComparator());
        return fList;
    }

    public final void generateTopKFrequentPatterns(Iterator<Pair<List<A>, Long>> transactionStream, Collection<Pair<A, Long>> frequencyList, long minSupport, int k, Collection<A> returnableFeatures, OutputCollector<A, List<Pair<List<A>, Long>>> output, StatusUpdater updater) throws IOException {
        HashMap<Integer, Comparable> reverseMapping = new HashMap<Integer, Comparable>();
        HashMap<Comparable, Integer> attributeIdMapping = new HashMap<Comparable, Integer>();
        int id = 0;
        for (Pair<A, Long> feature : frequencyList) {
            Comparable attrib = (Comparable)feature.getFirst();
            Long frequency = feature.getSecond();
            if (frequency < minSupport) continue;
            attributeIdMapping.put(attrib, id);
            reverseMapping.put(id++, attrib);
        }
        long[] attributeFrequency = new long[attributeIdMapping.size()];
        for (Pair<A, Long> feature : frequencyList) {
            Comparable attrib = (Comparable)feature.getFirst();
            Long frequency = feature.getSecond();
            if (frequency < minSupport) break;
            attributeFrequency[((Integer)attributeIdMapping.get((Object)attrib)).intValue()] = frequency;
        }
        log.info("Number of unique items {}", (Object)frequencyList.size());
        HashSet<Integer> returnFeatures = new HashSet<Integer>();
        if (returnableFeatures != null && !returnableFeatures.isEmpty()) {
            for (Comparable attrib : returnableFeatures) {
                if (!attributeIdMapping.containsKey(attrib)) continue;
                returnFeatures.add((Integer)attributeIdMapping.get(attrib));
                log.info("Adding Pattern {}=>{}", (Object)attrib, attributeIdMapping.get(attrib));
            }
        } else {
            for (int j = 0; j < attributeIdMapping.size(); ++j) {
                returnFeatures.add(j);
            }
        }
        log.info("Number of unique pruned items {}", (Object)attributeIdMapping.size());
        this.generateTopKFrequentPatterns((Iterator<Pair<int[], Long>>)((Object)new TransactionIterator(transactionStream, attributeIdMapping)), attributeFrequency, minSupport, k, reverseMapping.size(), (Collection<Integer>)returnFeatures, new TopKPatternsOutputConverter<A>(output, reverseMapping), updater);
    }

    private Map<Integer, FrequentPatternMaxHeap> fpGrowth(FPTree tree, long minSupportValue, int k, Collection<Integer> requiredFeatures, TopKPatternsOutputConverter<A> outputCollector, StatusUpdater updater) throws IOException {
        HashMap<Integer, FrequentPatternMaxHeap> patterns = new HashMap<Integer, FrequentPatternMaxHeap>();
        FPTreeDepthCache treeCache = new FPTreeDepthCache();
        for (int i = tree.getHeaderTableCount() - 1; i >= 0; --i) {
            int attribute = tree.getAttributeAtIndex(i);
            if (!requiredFeatures.contains(attribute)) continue;
            log.info("Mining FTree Tree for all patterns with {}", (Object)attribute);
            MutableLong minSupport = new MutableLong(minSupportValue);
            FrequentPatternMaxHeap frequentPatterns = FPGrowth.growth(tree, minSupport, k, treeCache, 0, attribute, updater);
            patterns.put(attribute, frequentPatterns);
            outputCollector.collect(attribute, frequentPatterns);
            minSupportValue = Math.max(minSupportValue, minSupport.longValue() / 2L);
            log.info("Found {} Patterns with Least Support {}", (Object)((FrequentPatternMaxHeap)patterns.get(attribute)).count(), (Object)((FrequentPatternMaxHeap)patterns.get(attribute)).leastSupport());
        }
        log.info("Tree Cache: First Level: Cache hits={} Cache Misses={}", (Object)treeCache.getHits(), (Object)treeCache.getMisses());
        return patterns;
    }

    private static FrequentPatternMaxHeap generateSinglePathPatterns(FPTree tree, int k, long minSupport) {
        FrequentPatternMaxHeap frequentPatterns = new FrequentPatternMaxHeap(k, false);
        int tempNode = 0;
        Pattern frequentItem = new Pattern();
        while (tree.childCount(tempNode) != 0) {
            if (tree.childCount(tempNode) > 1) {
                log.info("This should not happen {} {}", (Object)tree.childCount(tempNode), (Object)tempNode);
            }
            if (tree.count(tempNode = tree.childAtIndex(tempNode, 0)) < minSupport) continue;
            frequentItem.add(tree.attribute(tempNode), tree.count(tempNode));
        }
        if (frequentItem.length() > 0) {
            frequentPatterns.insert(frequentItem);
        }
        return frequentPatterns;
    }

    private Map<Integer, FrequentPatternMaxHeap> generateTopKFrequentPatterns(Iterator<Pair<int[], Long>> transactions, long[] attributeFrequency, long minSupport, int k, int featureSetSize, Collection<Integer> returnFeatures, TopKPatternsOutputConverter<A> topKPatternsOutputCollector, StatusUpdater updater) throws IOException {
        FPTree tree = new FPTree(featureSetSize);
        for (int i = 0; i < featureSetSize; ++i) {
            tree.addHeaderCount(i, attributeFrequency[i]);
        }
        int nodecount = 0;
        int i = 0;
        while (transactions.hasNext()) {
            Pair<int[], Long> transaction = transactions.next();
            Arrays.sort(transaction.getFirst());
            nodecount += FPGrowth.treeAddCount(tree, transaction.getFirst(), transaction.getSecond(), minSupport, attributeFrequency);
            if (++i % 10000 != 0) continue;
            log.info("FPTree Building: Read {} Transactions", (Object)i);
        }
        log.info("Number of Nodes in the FP Tree: {}", (Object)nodecount);
        return this.fpGrowth(tree, minSupport, k, returnFeatures, topKPatternsOutputCollector, updater);
    }

    private static FrequentPatternMaxHeap growth(FPTree tree, MutableLong minSupportMutable, int k, FPTreeDepthCache treeCache, int level, int currentAttribute, StatusUpdater updater) {
        FrequentPatternMaxHeap frequentPatterns = new FrequentPatternMaxHeap(k, true);
        int i = Arrays.binarySearch(tree.getHeaderTableAttributes(), currentAttribute);
        if (i < 0) {
            return frequentPatterns;
        }
        int headerTableCount = tree.getHeaderTableCount();
        while (i < headerTableCount) {
            FrequentPatternMaxHeap returnedPatterns;
            int attribute = tree.getAttributeAtIndex(i);
            long count = tree.getHeaderSupportCount(attribute);
            if (count < minSupportMutable.longValue()) {
                ++i;
                continue;
            }
            updater.update("FPGrowth Algorithm for a given feature: " + attribute);
            FPTree conditionalTree = treeCache.getFirstLevelTree(attribute);
            if (conditionalTree.isEmpty()) {
                FPGrowth.traverseAndBuildConditionalFPTreeData(tree.getHeaderNext(attribute), minSupportMutable.longValue(), conditionalTree, tree);
            }
            if (attribute == currentAttribute) {
                returnedPatterns = FPGrowth.growthTopDown(conditionalTree, minSupportMutable, k, treeCache, level + 1, true, currentAttribute, updater);
                frequentPatterns = FPGrowth.mergeHeap(frequentPatterns, returnedPatterns, attribute, count, true);
            } else {
                returnedPatterns = FPGrowth.growthTopDown(conditionalTree, minSupportMutable, k, treeCache, level + 1, false, currentAttribute, updater);
                frequentPatterns = FPGrowth.mergeHeap(frequentPatterns, returnedPatterns, attribute, count, false);
            }
            if (frequentPatterns.isFull() && minSupportMutable.longValue() < frequentPatterns.leastSupport()) {
                minSupportMutable.setValue(frequentPatterns.leastSupport());
            }
            ++i;
        }
        return frequentPatterns;
    }

    private static FrequentPatternMaxHeap growthBottomUp(FPTree tree, MutableLong minSupportMutable, int k, FPTreeDepthCache treeCache, int level, boolean conditionalOfCurrentAttribute, int currentAttribute, StatusUpdater updater) {
        long count;
        int attribute;
        FrequentPatternMaxHeap frequentPatterns = new FrequentPatternMaxHeap(k, false);
        if (!conditionalOfCurrentAttribute) {
            int index = Arrays.binarySearch(tree.getHeaderTableAttributes(), currentAttribute);
            if (index < 0) {
                return frequentPatterns;
            }
            attribute = tree.getAttributeAtIndex(index);
            count = tree.getHeaderSupportCount(attribute);
            if (count < minSupportMutable.longValue()) {
                return frequentPatterns;
            }
        }
        if (tree.singlePath()) {
            return FPGrowth.generateSinglePathPatterns(tree, k, minSupportMutable.longValue());
        }
        updater.update("Bottom Up FP Growth");
        for (int i = tree.getHeaderTableCount() - 1; i >= 0; --i) {
            FrequentPatternMaxHeap returnedPatterns;
            attribute = tree.getAttributeAtIndex(i);
            count = tree.getHeaderSupportCount(attribute);
            if (count < minSupportMutable.longValue()) continue;
            FPTree conditionalTree = treeCache.getTree(level);
            if (conditionalOfCurrentAttribute) {
                FPGrowth.traverseAndBuildConditionalFPTreeData(tree.getHeaderNext(attribute), minSupportMutable.longValue(), conditionalTree, tree);
                returnedPatterns = FPGrowth.growthBottomUp(conditionalTree, minSupportMutable, k, treeCache, level + 1, true, currentAttribute, updater);
                frequentPatterns = FPGrowth.mergeHeap(frequentPatterns, returnedPatterns, attribute, count, true);
            } else if (attribute == currentAttribute) {
                FPGrowth.traverseAndBuildConditionalFPTreeData(tree.getHeaderNext(attribute), minSupportMutable.longValue(), conditionalTree, tree);
                returnedPatterns = FPGrowth.growthBottomUp(conditionalTree, minSupportMutable, k, treeCache, level + 1, true, currentAttribute, updater);
                frequentPatterns = FPGrowth.mergeHeap(frequentPatterns, returnedPatterns, attribute, count, true);
            } else if (attribute > currentAttribute) {
                FPGrowth.traverseAndBuildConditionalFPTreeData(tree.getHeaderNext(attribute), minSupportMutable.longValue(), conditionalTree, tree);
                returnedPatterns = FPGrowth.growthBottomUp(conditionalTree, minSupportMutable, k, treeCache, level + 1, false, currentAttribute, updater);
                frequentPatterns = FPGrowth.mergeHeap(frequentPatterns, returnedPatterns, attribute, count, false);
            }
            if (!frequentPatterns.isFull() || minSupportMutable.longValue() >= frequentPatterns.leastSupport()) continue;
            minSupportMutable.setValue(frequentPatterns.leastSupport());
        }
        return frequentPatterns;
    }

    private static FrequentPatternMaxHeap growthTopDown(FPTree tree, MutableLong minSupportMutable, int k, FPTreeDepthCache treeCache, int level, boolean conditionalOfCurrentAttribute, int currentAttribute, StatusUpdater updater) {
        long count;
        int attribute;
        FrequentPatternMaxHeap frequentPatterns = new FrequentPatternMaxHeap(k, true);
        if (!conditionalOfCurrentAttribute) {
            int index = Arrays.binarySearch(tree.getHeaderTableAttributes(), currentAttribute);
            if (index < 0) {
                return frequentPatterns;
            }
            attribute = tree.getAttributeAtIndex(index);
            count = tree.getHeaderSupportCount(attribute);
            if (count < minSupportMutable.longValue()) {
                return frequentPatterns;
            }
        }
        if (tree.singlePath()) {
            return FPGrowth.generateSinglePathPatterns(tree, k, minSupportMutable.longValue());
        }
        updater.update("Top Down Growth:");
        for (int i = 0; i < tree.getHeaderTableCount(); ++i) {
            FrequentPatternMaxHeap returnedPatterns;
            attribute = tree.getAttributeAtIndex(i);
            count = tree.getHeaderSupportCount(attribute);
            if (count < minSupportMutable.longValue()) continue;
            FPTree conditionalTree = treeCache.getTree(level);
            if (conditionalOfCurrentAttribute) {
                FPGrowth.traverseAndBuildConditionalFPTreeData(tree.getHeaderNext(attribute), minSupportMutable.longValue(), conditionalTree, tree);
                returnedPatterns = FPGrowth.growthBottomUp(conditionalTree, minSupportMutable, k, treeCache, level + 1, true, currentAttribute, updater);
                frequentPatterns = FPGrowth.mergeHeap(frequentPatterns, returnedPatterns, attribute, count, true);
            } else if (attribute == currentAttribute) {
                FPGrowth.traverseAndBuildConditionalFPTreeData(tree.getHeaderNext(attribute), minSupportMutable.longValue(), conditionalTree, tree);
                returnedPatterns = FPGrowth.growthBottomUp(conditionalTree, minSupportMutable, k, treeCache, level + 1, true, currentAttribute, updater);
                frequentPatterns = FPGrowth.mergeHeap(frequentPatterns, returnedPatterns, attribute, count, true);
            } else if (attribute > currentAttribute) {
                FPGrowth.traverseAndBuildConditionalFPTreeData(tree.getHeaderNext(attribute), minSupportMutable.longValue(), conditionalTree, tree);
                returnedPatterns = FPGrowth.growthBottomUp(conditionalTree, minSupportMutable, k, treeCache, level + 1, false, currentAttribute, updater);
                frequentPatterns = FPGrowth.mergeHeap(frequentPatterns, returnedPatterns, attribute, count, false);
            }
            if (!frequentPatterns.isFull() || minSupportMutable.longValue() >= frequentPatterns.leastSupport()) continue;
            minSupportMutable.setValue(frequentPatterns.leastSupport());
        }
        return frequentPatterns;
    }

    private static FrequentPatternMaxHeap mergeHeap(FrequentPatternMaxHeap frequentPatterns, FrequentPatternMaxHeap returnedPatterns, int attribute, long count, boolean addAttribute) {
        frequentPatterns.addAll(returnedPatterns, attribute, count);
        if (frequentPatterns.addable(count) && addAttribute) {
            Pattern p = new Pattern();
            p.add(attribute, count);
            frequentPatterns.insert(p);
        }
        return frequentPatterns;
    }

    private static void traverseAndBuildConditionalFPTreeData(int firstConditionalNode, long minSupport, FPTree conditionalTree, FPTree tree) {
        int conditionalNode = firstConditionalNode;
        while (conditionalNode != -1) {
            long nextNodeCount = tree.count(conditionalNode);
            int pathNode = tree.parent(conditionalNode);
            int prevConditional = -1;
            while (pathNode != 0) {
                int attribute = tree.attribute(pathNode);
                if (tree.getHeaderSupportCount(attribute) < minSupport) {
                    pathNode = tree.parent(pathNode);
                    continue;
                }
                conditionalTree.addHeaderCount(attribute, nextNodeCount);
                int conditional = tree.conditional(pathNode);
                if (conditional == 0) {
                    tree.setConditional(pathNode, conditionalTree.createConditionalNode(attribute, 0L));
                    conditional = tree.conditional(pathNode);
                    conditionalTree.addHeaderNext(attribute, conditional);
                } else {
                    conditionalTree.setSinglePath(false);
                }
                if (prevConditional != -1) {
                    conditionalTree.setParent(prevConditional, conditional);
                }
                conditionalTree.addCount(conditional, nextNodeCount);
                prevConditional = conditional;
                pathNode = tree.parent(pathNode);
            }
            if (prevConditional != -1) {
                conditionalTree.setParent(prevConditional, 0);
                if (conditionalTree.childCount(0) > 1 && conditionalTree.singlePath()) {
                    conditionalTree.setSinglePath(false);
                }
            }
            conditionalNode = tree.next(conditionalNode);
        }
        tree.clearConditional();
        conditionalTree.reorderHeaderTable();
        FPGrowth.pruneFPTree(minSupport, conditionalTree);
    }

    private static void pruneFPTree(long minSupport, FPTree tree) {
        int nextNode;
        int currentAttribute;
        int i;
        for (i = 0; i < tree.getHeaderTableCount(); ++i) {
            currentAttribute = tree.getAttributeAtIndex(i);
            if (tree.getHeaderSupportCount(currentAttribute) >= minSupport) continue;
            nextNode = tree.getHeaderNext(currentAttribute);
            tree.removeHeaderNext(currentAttribute);
            while (nextNode != -1) {
                int mychildCount = tree.childCount(nextNode);
                int parentNode = tree.parent(nextNode);
                for (int j = 0; j < mychildCount; ++j) {
                    Integer myChildId = tree.childAtIndex(nextNode, j);
                    tree.replaceChild(parentNode, nextNode, myChildId);
                }
                nextNode = tree.next(nextNode);
            }
        }
        for (i = 0; i < tree.getHeaderTableCount(); ++i) {
            currentAttribute = tree.getAttributeAtIndex(i);
            nextNode = tree.getHeaderNext(currentAttribute);
            OpenIntIntHashMap prevNode = new OpenIntIntHashMap();
            int justPrevNode = -1;
            while (nextNode != -1) {
                int parent = tree.parent(nextNode);
                if (prevNode.containsKey(parent)) {
                    int prevNodeId = prevNode.get(parent);
                    if (tree.childCount(prevNodeId) <= 1 && tree.childCount(nextNode) <= 1) {
                        tree.addCount(prevNodeId, tree.count(nextNode));
                        tree.addCount(nextNode, -1L * tree.count(nextNode));
                        if (tree.childCount(nextNode) == 1) {
                            tree.addChild(prevNodeId, tree.childAtIndex(nextNode, 0));
                            tree.setParent(tree.childAtIndex(nextNode, 0), prevNodeId);
                        }
                        tree.setNext(justPrevNode, tree.next(nextNode));
                    }
                } else {
                    prevNode.put(parent, nextNode);
                }
                justPrevNode = nextNode;
                nextNode = tree.next(nextNode);
            }
        }
    }

    private static int treeAddCount(FPTree tree, int[] myList, long addCount, long minSupport, long[] attributeFrequency) {
        int temp = 0;
        int ret = 0;
        boolean addCountMode = true;
        for (int attribute : myList) {
            int child;
            if (attributeFrequency[attribute] < minSupport) {
                return ret;
            }
            if (addCountMode) {
                child = tree.childWithAttribute(temp, attribute);
                if (child == -1) {
                    addCountMode = false;
                } else {
                    tree.addCount(child, addCount);
                    temp = child;
                }
            }
            if (addCountMode) continue;
            temp = child = tree.createNode(temp, attribute, addCount);
            ++ret;
        }
        return ret;
    }
}

