/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.convertors.integer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.mahout.common.Pair;
import org.apache.mahout.fpm.pfpgrowth.convertors.string.TopKStringPatterns;

public final class IntegerStringOutputConverter
implements OutputCollector<Integer, List<Pair<List<Integer>, Long>>> {
    private final OutputCollector<Text, TopKStringPatterns> collector;
    private final List<String> featureReverseMap;

    public IntegerStringOutputConverter(OutputCollector<Text, TopKStringPatterns> collector, List<String> featureReverseMap) {
        this.collector = collector;
        this.featureReverseMap = featureReverseMap;
    }

    public void collect(Integer key, List<Pair<List<Integer>, Long>> value) throws IOException {
        String stringKey = this.featureReverseMap.get(key);
        ArrayList<Pair<List<String>, Long>> stringValues = new ArrayList<Pair<List<String>, Long>>();
        for (Pair<List<Integer>, Long> e : value) {
            ArrayList<String> pattern = new ArrayList<String>();
            for (Integer i : e.getFirst()) {
                pattern.add(this.featureReverseMap.get(i));
            }
            stringValues.add(new Pair(pattern, e.getSecond()));
        }
        this.collector.collect((Object)new Text(stringKey), (Object)new TopKStringPatterns(stringValues));
    }
}

