/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.fpm.pfpgrowth.PFPGrowth;
import org.apache.mahout.fpm.pfpgrowth.TransactionTree;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public class TransactionSortingMapper
extends Mapper<LongWritable, Text, LongWritable, TransactionTree> {
    private final OpenObjectIntHashMap<String> fMap = new OpenObjectIntHashMap();
    private Pattern splitter;

    protected void map(LongWritable offset, Text input, Mapper.Context context) throws IOException, InterruptedException {
        String[] items = this.splitter.split(input.toString());
        HashSet<String> uniqueItems = new HashSet<String>(Arrays.asList(items));
        ArrayList<Integer> itemSet = new ArrayList<Integer>();
        for (String item : uniqueItems) {
            if (!this.fMap.containsKey((Object)item) || item.trim().length() == 0) continue;
            itemSet.add(this.fMap.get((Object)item));
        }
        Collections.sort(itemSet);
        Integer[] prunedItems = itemSet.toArray(new Integer[itemSet.size()]);
        if (prunedItems.length > 0) {
            context.write((Object)new LongWritable((long)prunedItems[0].intValue()), (Object)new TransactionTree(prunedItems, 1L));
        }
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Parameters params = new Parameters(context.getConfiguration().get("pfp.parameters", ""));
        int i = 0;
        for (Pair<String, Long> e : PFPGrowth.deserializeList(params, "fList", context.getConfiguration())) {
            this.fMap.put((Object)e.getFirst(), i++);
        }
        this.splitter = Pattern.compile(params.get("splitPattern", PFPGrowth.SPLITTER.toString()));
    }
}

