/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.fpm.pfpgrowth.CountDescendingPairComparator;
import org.apache.mahout.fpm.pfpgrowth.PFPGrowth;
import org.apache.mahout.fpm.pfpgrowth.TransactionTree;
import org.apache.mahout.fpm.pfpgrowth.convertors.ContextStatusUpdater;
import org.apache.mahout.fpm.pfpgrowth.convertors.ContextWriteOutputCollector;
import org.apache.mahout.fpm.pfpgrowth.convertors.integer.IntegerStringOutputConverter;
import org.apache.mahout.fpm.pfpgrowth.convertors.string.TopKStringPatterns;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FPGrowth;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenLongObjectHashMap;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public class ParallelFPGrowthReducer
extends Reducer<LongWritable, TransactionTree, Text, TopKStringPatterns> {
    private final List<String> featureReverseMap = new ArrayList<String>();
    private final OpenObjectIntHashMap<String> fMap = new OpenObjectIntHashMap();
    private final OpenLongObjectHashMap<IntArrayList> groupFeatures = new OpenLongObjectHashMap();
    private int maxHeapSize = 50;
    private int minSupport = 3;

    protected void reduce(LongWritable key, Iterable<TransactionTree> values, Reducer.Context context) throws IOException {
        TransactionTree cTree = new TransactionTree();
        for (TransactionTree tr : values) {
            for (Pair<List<Integer>, Long> p : tr) {
                cTree.addPattern((Iterable<Integer>)p.getFirst(), p.getSecond());
            }
        }
        ArrayList localFList = new ArrayList();
        for (Map.Entry<Integer, MutableLong> fItem : cTree.generateFList().entrySet()) {
            localFList.add(new Pair<Integer, Long>(fItem.getKey(), fItem.getValue().toLong()));
        }
        Collections.sort(localFList, new CountDescendingPairComparator());
        FPGrowth<Integer> fpGrowth = new FPGrowth<Integer>();
        fpGrowth.generateTopKFrequentPatterns(cTree.iterator(), localFList, this.minSupport, this.maxHeapSize, new HashSet(((IntArrayList)this.groupFeatures.get(key.get())).toList()), new IntegerStringOutputConverter(new ContextWriteOutputCollector(context), this.featureReverseMap), new ContextStatusUpdater(context));
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Parameters params = new Parameters(context.getConfiguration().get("pfp.parameters", ""));
        int i = 0;
        for (Pair<String, Long> e : PFPGrowth.deserializeList(params, "fList", context.getConfiguration())) {
            this.featureReverseMap.add(e.getFirst());
            this.fMap.put((Object)e.getFirst(), i++);
        }
        Map<String, Long> gList = PFPGrowth.deserializeMap(params, "gList", context.getConfiguration());
        for (Map.Entry<String, Long> entry : gList.entrySet()) {
            IntArrayList groupList = (IntArrayList)this.groupFeatures.get(entry.getValue().longValue());
            Integer itemInteger = this.fMap.get((Object)entry.getKey());
            if (groupList != null) {
                groupList.add(itemInteger.intValue());
                continue;
            }
            groupList = new IntArrayList();
            groupList.add(itemInteger.intValue());
            this.groupFeatures.put(entry.getValue().longValue(), (Object)groupList);
        }
        this.maxHeapSize = Integer.valueOf(params.get("maxHeapSize", "50"));
        this.minSupport = Integer.valueOf(params.get("minSupport", "3"));
    }
}

