/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.fpm.pfpgrowth.PFPGrowth;
import org.apache.mahout.fpm.pfpgrowth.TransactionTree;
import org.apache.mahout.math.map.OpenIntLongHashMap;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public class ParallelFPGrowthMapper
extends Mapper<LongWritable, TransactionTree, LongWritable, TransactionTree> {
    private final OpenIntLongHashMap gListInt = new OpenIntLongHashMap();

    protected void map(LongWritable offset, TransactionTree input, Mapper.Context context) throws IOException, InterruptedException {
        for (Pair<List<Integer>, Long> pattern : input) {
            Integer[] prunedItems = pattern.getFirst().toArray(new Integer[pattern.getFirst().size()]);
            HashSet<Long> groups = new HashSet<Long>();
            for (int j = prunedItems.length - 1; j >= 0; --j) {
                Integer item = prunedItems[j];
                Long groupID = this.gListInt.get(item.intValue());
                if (!groups.contains(groupID)) {
                    Integer[] tempItems = new Integer[j + 1];
                    System.arraycopy(prunedItems, 0, tempItems, 0, j + 1);
                    context.setStatus("Parallel FPGrowth: Generating Group Dependent transactions for: " + item);
                    context.write((Object)new LongWritable(groupID.longValue()), (Object)new TransactionTree(tempItems, pattern.getSecond()));
                }
                groups.add(groupID);
            }
        }
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Parameters params = new Parameters(context.getConfiguration().get("pfp.parameters", ""));
        OpenObjectIntHashMap fMap = new OpenObjectIntHashMap();
        int i = 0;
        for (Pair<String, Long> pair : PFPGrowth.deserializeList(params, "fList", context.getConfiguration())) {
            fMap.put((Object)pair.getFirst(), i++);
        }
        for (Map.Entry entry : PFPGrowth.deserializeMap(params, "gList", context.getConfiguration()).entrySet()) {
            this.gListInt.put(fMap.get(entry.getKey()), ((Long)entry.getValue()).longValue());
        }
    }
}

