/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.common.iterator.StringRecordIterator;
import org.apache.mahout.fpm.pfpgrowth.PFPGrowth;
import org.apache.mahout.fpm.pfpgrowth.convertors.ContextStatusUpdater;
import org.apache.mahout.fpm.pfpgrowth.convertors.SequenceFileOutputCollector;
import org.apache.mahout.fpm.pfpgrowth.convertors.string.StringOutputConverter;
import org.apache.mahout.fpm.pfpgrowth.convertors.string.TopKStringPatterns;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FPGrowth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FPGrowthDriver {
    private static final Logger log = LoggerFactory.getLogger(FPGrowthDriver.class);

    private FPGrowthDriver() {
    }

    public static void main(String[] args) throws Exception {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputDirOpt = obuilder.withLongName("input").withRequired(true).withArgument(abuilder.withName("input").withMinimum(1).withMaximum(1).create()).withDescription("The Directory on HDFS containing the transaction files").withShortName("i").create();
        DefaultOption outputOpt = DefaultOptionCreator.outputOption().create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        DefaultOption minSupportOpt = obuilder.withLongName("minSupport").withArgument(abuilder.withName("minSupport").withMinimum(1).withMaximum(1).create()).withDescription("(Optional) Minimum Support. Default Value: 3").withShortName("s").create();
        DefaultOption maxHeapSizeOpt = obuilder.withLongName("maxHeapSize").withArgument(abuilder.withName("maxHeapSize").withMinimum(1).withMaximum(1).create()).withDescription("(Optional) Maximum Heap Size k, to denote the requirement to mine top K items. Default value: 50").withShortName("k").create();
        DefaultOption numGroupsOpt = obuilder.withLongName("numGroups").withArgument(abuilder.withName("numGroups").withMinimum(1).withMaximum(1).create()).withDescription("(Optional) Number of groups the features should be divided in the map-reduce version. Doesn't work in sequential version Default Value:1000").withShortName("g").create();
        DefaultOption recordSplitterOpt = obuilder.withLongName("splitterPattern").withArgument(abuilder.withName("splitterPattern").withMinimum(1).withMaximum(1).create()).withDescription("Regular Expression pattern used to split given string transaction into itemsets. Default value splits comma separated itemsets.  Default Value: \"[ ,\\t]*[,|\\t][ ,\\t]*\" ").withShortName("regex").create();
        DefaultOption treeCacheOpt = obuilder.withLongName("numTreeCacheEntries").withArgument(abuilder.withName("numTreeCacheEntries").withMinimum(1).withMaximum(1).create()).withDescription("(Optional) Number of entries in the tree cache to prevent duplicate tree building. (Warning) a first level conditional FP-Tree might consume a lot of memory, so keep this value small, but big enough to prevent duplicate tree building. Default Value:5 Recommended Values: [5-10]").withShortName("tc").create();
        DefaultOption methodOpt = obuilder.withLongName("method").withRequired(true).withArgument(abuilder.withName("method").withMinimum(1).withMaximum(1).create()).withDescription("Method of processing: sequential|mapreduce").withShortName("method").create();
        DefaultOption encodingOpt = obuilder.withLongName("encoding").withArgument(abuilder.withName("encoding").withMinimum(1).withMaximum(1).create()).withDescription("(Optional) The file encoding.  Default value: UTF-8").withShortName("e").create();
        Group group = gbuilder.withName("Options").withOption((Option)minSupportOpt).withOption((Option)inputDirOpt).withOption((Option)outputOpt).withOption((Option)maxHeapSizeOpt).withOption((Option)numGroupsOpt).withOption((Option)methodOpt).withOption((Option)encodingOpt).withOption(helpOpt).withOption((Option)treeCacheOpt).withOption((Option)recordSplitterOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp(group);
                return;
            }
            Parameters params = new Parameters();
            if (cmdLine.hasOption((Option)minSupportOpt)) {
                String minSupportString = (String)cmdLine.getValue((Option)minSupportOpt);
                params.set("minSupport", minSupportString);
            }
            if (cmdLine.hasOption((Option)maxHeapSizeOpt)) {
                String maxHeapSizeString = (String)cmdLine.getValue((Option)maxHeapSizeOpt);
                params.set("maxHeapSize", maxHeapSizeString);
            }
            if (cmdLine.hasOption((Option)numGroupsOpt)) {
                String numGroupsString = (String)cmdLine.getValue((Option)numGroupsOpt);
                params.set("numGroups", numGroupsString);
            }
            if (cmdLine.hasOption((Option)treeCacheOpt)) {
                String numTreeCacheString = (String)cmdLine.getValue((Option)treeCacheOpt);
                params.set("treeCacheSize", numTreeCacheString);
            }
            if (cmdLine.hasOption((Option)recordSplitterOpt)) {
                String patternString = (String)cmdLine.getValue((Option)recordSplitterOpt);
                params.set("splitPattern", patternString);
            }
            String encoding = "UTF-8";
            if (cmdLine.hasOption((Option)encodingOpt)) {
                encoding = (String)cmdLine.getValue((Option)encodingOpt);
            }
            params.set("encoding", encoding);
            Path inputDir = new Path(cmdLine.getValue((Option)inputDirOpt).toString());
            Path outputDir = new Path(cmdLine.getValue((Option)outputOpt).toString());
            params.set("input", inputDir.toString());
            params.set("output", outputDir.toString());
            String classificationMethod = (String)cmdLine.getValue((Option)methodOpt);
            if ("sequential".equalsIgnoreCase(classificationMethod)) {
                FPGrowthDriver.runFPGrowth(params);
            } else if ("mapreduce".equalsIgnoreCase(classificationMethod)) {
                Configuration conf = new Configuration();
                HadoopUtil.delete(conf, outputDir);
                PFPGrowth.runPFPGrowth(params);
            }
        }
        catch (OptionException e) {
            CommandLineUtil.printHelp(group);
        }
    }

    private static void runFPGrowth(Parameters params) throws IOException {
        log.info("Starting Sequential FPGrowth");
        int maxHeapSize = Integer.valueOf(params.get("maxHeapSize", "50"));
        int minSupport = Integer.valueOf(params.get("minSupport", "3"));
        String output = params.get("output", "output.txt");
        Path path = new Path(output);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Charset encoding = Charset.forName(params.get("encoding"));
        String input = params.get("input");
        String pattern = params.get("splitPattern", PFPGrowth.SPLITTER.toString());
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, path, Text.class, TopKStringPatterns.class);
        FPGrowth<String> fp = new FPGrowth<String>();
        HashSet features = new HashSet();
        fp.generateTopKFrequentPatterns((Iterator<Pair<List<String>, Long>>)((Object)new StringRecordIterator(new FileLineIterable(new File(input), encoding, false), pattern)), fp.generateFList((Iterator<Pair<List<String>, Long>>)((Object)new StringRecordIterator(new FileLineIterable(new File(input), encoding, false), pattern)), minSupport), minSupport, maxHeapSize, features, new StringOutputConverter(new SequenceFileOutputCollector<Text, TopKStringPatterns>(writer)), new ContextStatusUpdater(null));
        writer.close();
        List<Pair<String, TopKStringPatterns>> frequentPatterns = FPGrowth.readFrequentPattern(conf, path);
        for (Pair<String, TopKStringPatterns> entry : frequentPatterns) {
            log.info("Dumping Patterns for Feature: {} \n{}", (Object)entry.getFirst(), (Object)entry.getSecond());
        }
    }
}

