/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ep;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Deque;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.mahout.ep.Mapping;
import org.apache.mahout.ep.State;

public class ThreadedEvolutionaryProcess {
    private static final PriorityQueue<State<?, ?>> resultPopulation = new PriorityQueue();
    private volatile int taskCount;
    private volatile int processCount;
    private volatile int maxTask;
    private final Deque<State<?, ?>> pending = Lists.newLinkedList();
    private final Set<Future<State<?, ?>>> working = Sets.newHashSet();
    private final ExecutorService pool;
    private final ExecutorCompletionService<State<?, ?>> ecs;
    private final int threadCount;
    private final Map<Integer, Mapping> mappingTable = Maps.newHashMap();

    public ThreadedEvolutionaryProcess(int threadCount) {
        this.threadCount = threadCount;
        this.pool = Executors.newFixedThreadPool(threadCount);
        this.ecs = new ExecutorCompletionService(this.pool);
    }

    public void setMap(int i, Mapping m) {
        this.mappingTable.put(i, m);
    }

    public State<?, ?> optimize(Function f, int dim, long timeLimit, int parentDepth) throws InterruptedException, ExecutionException {
        Future<State<?, ?>> result;
        long t0 = System.currentTimeMillis();
        State s0 = new State(new double[dim], 0.5);
        for (Map.Entry<Integer, Mapping> entry : this.mappingTable.entrySet()) {
            s0.setMap(entry.getKey(), entry.getValue());
        }
        this.pending.add(s0);
        while (this.pending.size() < this.threadCount) {
            this.pending.add(s0.mutate());
        }
        while (true) {
            if (this.working.size() < this.threadCount && !this.pending.isEmpty()) {
                State<?, ?> next = this.pending.removeFirst();
                this.working.add(this.ecs.submit(new EvalTask(f, next)));
                ++this.processCount;
                continue;
            }
            result = this.ecs.take();
            while (result != null) {
                State<?, ?> r = result.get();
                resultPopulation.add(r);
                this.working.remove(result);
                result = this.ecs.poll();
            }
            State[] parents = new State[parentDepth];
            Iterator<State<?, ?>> j = resultPopulation.iterator();
            for (int i = 0; i < parentDepth && j.hasNext(); ++i) {
                parents[i] = j.next();
            }
            int k = 0;
            while (this.pending.size() + this.working.size() < this.threadCount) {
                State tmp = parents[k++ % parentDepth];
                this.pending.add(tmp.mutate());
            }
            if (System.currentTimeMillis() - t0 >= timeLimit) break;
        }
        while (!this.working.isEmpty()) {
            result = this.ecs.take();
            this.working.remove(result);
            resultPopulation.add(result.get());
        }
        this.pool.shutdown();
        return resultPopulation.peek();
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "Launched %d function evaluations\nMaximum threading width was %d", this.processCount, this.maxTask);
    }

    public static interface Function {
        public double apply(double[] var1);
    }

    public class EvalTask
    implements Callable<State<?, ?>> {
        private final Function f;
        private final State<?, ?> what;

        public EvalTask(Function f, State<?, ?> what) {
            this.f = f;
            this.what = what;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public State<?, ?> call() {
            ThreadedEvolutionaryProcess.this.taskCount++;
            ThreadedEvolutionaryProcess.this.maxTask = Math.max(ThreadedEvolutionaryProcess.this.taskCount, ThreadedEvolutionaryProcess.this.maxTask);
            try {
                this.what.setValue(this.f.apply(this.what.getMappedParams()));
                State<?, ?> state = this.what;
                return state;
            }
            finally {
                ThreadedEvolutionaryProcess.this.taskCount--;
            }
        }
    }
}

