/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.df.DFUtils;
import org.apache.mahout.df.data.DataLoader;
import org.apache.mahout.df.data.Dataset;
import org.apache.mahout.df.data.DescriptorException;
import org.apache.mahout.df.data.DescriptorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Describe {
    private static final Logger log = LoggerFactory.getLogger(Describe.class);

    private Describe() {
    }

    public static void main(String[] args) throws IOException, DescriptorException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption pathOpt = obuilder.withLongName("path").withShortName("p").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Data path").create();
        DefaultOption descriptorOpt = obuilder.withLongName("descriptor").withShortName("d").withRequired(true).withArgument(abuilder.withName("descriptor").withMinimum(1).create()).withDescription("data descriptor").create();
        DefaultOption descPathOpt = obuilder.withLongName("file").withShortName("f").withRequired(true).withArgument(abuilder.withName("file").withMinimum(1).withMaximum(1).create()).withDescription("Path to generated descriptor file").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption((Option)pathOpt).withOption((Option)descPathOpt).withOption((Option)descriptorOpt).withOption((Option)helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption((Option)helpOpt)) {
                CommandLineUtil.printHelp(group);
                return;
            }
            String dataPath = cmdLine.getValue((Option)pathOpt).toString();
            String descPath = cmdLine.getValue((Option)descPathOpt).toString();
            List<String> descriptor = Describe.convert(cmdLine.getValues((Option)descriptorOpt));
            log.debug("Data path : {}", (Object)dataPath);
            log.debug("Descriptor path : {}", (Object)descPath);
            log.debug("Descriptor : {}", descriptor);
            Describe.runTool(dataPath, descriptor, descPath);
        }
        catch (OptionException e) {
            log.warn(e.toString());
            CommandLineUtil.printHelp(group);
        }
    }

    private static void runTool(String dataPath, Iterable<String> description, String filePath) throws DescriptorException, IOException {
        log.info("Generating the descriptor...");
        String descriptor = DescriptorUtils.generateDescriptor(description);
        Path fPath = Describe.validateOutput(filePath);
        log.info("generating the dataset...");
        Dataset dataset = Describe.generateDataset(descriptor, dataPath);
        log.info("storing the dataset description");
        DFUtils.storeWritable(new Configuration(), fPath, dataset);
    }

    private static Dataset generateDataset(String descriptor, String dataPath) throws IOException, DescriptorException {
        Path path = new Path(dataPath);
        FileSystem fs = path.getFileSystem(new Configuration());
        return DataLoader.generateDataset(descriptor, fs, path);
    }

    private static Path validateOutput(String filePath) throws IOException {
        Path path = new Path(filePath);
        FileSystem fs = path.getFileSystem(new Configuration());
        if (fs.exists(path)) {
            throw new IllegalStateException("Descriptor's file already exists");
        }
        return path;
    }

    private static List<String> convert(Collection<?> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (Object value : values) {
            list.add(value.toString());
        }
        return list;
    }
}

