/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.ref;

import java.util.ArrayList;
import java.util.Random;
import org.apache.mahout.df.Bagging;
import org.apache.mahout.df.DecisionForest;
import org.apache.mahout.df.builder.TreeBuilder;
import org.apache.mahout.df.callback.PredictionCallback;
import org.apache.mahout.df.data.Data;
import org.apache.mahout.df.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialBuilder {
    private static final Logger log = LoggerFactory.getLogger(SequentialBuilder.class);
    private final Random rng;
    private final Bagging bagging;

    public SequentialBuilder(Random rng, TreeBuilder treeBuilder, Data data) {
        this.rng = rng;
        this.bagging = new Bagging(treeBuilder, data);
    }

    public DecisionForest build(int nbTrees, PredictionCallback callback) {
        ArrayList<Node> trees = new ArrayList<Node>();
        for (int treeId = 0; treeId < nbTrees; ++treeId) {
            trees.add(this.bagging.build(treeId, this.rng, callback));
            SequentialBuilder.logProgress(((float)treeId + 1.0f) / (float)nbTrees);
        }
        return new DecisionForest(trees);
    }

    private static void logProgress(float progress) {
        int percent = (int)(progress * 100.0f);
        if (percent % 10 == 0) {
            log.info("Building {}%", (Object)percent);
        }
    }
}

