/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.node;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.mahout.df.DFUtils;
import org.apache.mahout.df.data.Instance;
import org.apache.mahout.df.node.Node;

public class CategoricalNode
extends Node {
    private int attr;
    private double[] values;
    private Node[] childs;

    public CategoricalNode() {
    }

    public CategoricalNode(int attr, double[] values, Node[] childs) {
        this.attr = attr;
        this.values = values;
        this.childs = childs;
    }

    @Override
    public int classify(Instance instance) {
        int index = ArrayUtils.indexOf((double[])this.values, (double)instance.get(this.attr));
        if (index == -1) {
            return -1;
        }
        return this.childs[index].classify(instance);
    }

    @Override
    public long maxDepth() {
        long max = 0L;
        for (Node child : this.childs) {
            long depth = child.maxDepth();
            if (depth <= max) continue;
            max = depth;
        }
        return 1L + max;
    }

    @Override
    public long nbNodes() {
        long nbNodes = 1L;
        for (Node child : this.childs) {
            nbNodes += child.nbNodes();
        }
        return nbNodes;
    }

    @Override
    protected Node.Type getType() {
        return Node.Type.CATEGORICAL;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CategoricalNode)) {
            return false;
        }
        CategoricalNode node = (CategoricalNode)obj;
        return this.attr == node.attr && Arrays.equals(this.values, node.values) && Arrays.equals(this.childs, node.childs);
    }

    public int hashCode() {
        int hashCode = this.attr;
        for (double value : this.values) {
            hashCode = 31 * hashCode + (int)Double.doubleToLongBits(value);
        }
        for (Node node : this.childs) {
            hashCode = 31 * hashCode + node.hashCode();
        }
        return hashCode;
    }

    @Override
    protected String getString() {
        StringBuilder buffer = new StringBuilder();
        for (Node child : this.childs) {
            buffer.append(child).append(',');
        }
        return buffer.toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.attr = in.readInt();
        this.values = DFUtils.readDoubleArray(in);
        this.childs = DFUtils.readNodeArray(in);
    }

    @Override
    protected void writeNode(DataOutput out) throws IOException {
        out.writeInt(this.attr);
        DFUtils.writeArray(out, this.values);
        DFUtils.writeArray(out, this.childs);
    }
}

