/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce.partial;

import com.google.common.base.Preconditions;
import org.apache.hadoop.io.LongWritable;

public class TreeID
extends LongWritable
implements Cloneable {
    public static final int MAX_TREEID = 100000;

    public TreeID() {
    }

    public TreeID(int partition, int treeId) {
        Preconditions.checkArgument((partition >= 0 ? 1 : 0) != 0, (Object)"partition < 0");
        Preconditions.checkArgument((treeId >= 0 ? 1 : 0) != 0, (Object)"treeId < 0");
        this.set(partition, treeId);
    }

    public void set(int partition, int treeId) {
        super.set((long)partition * 100000L + (long)treeId);
    }

    public int partition() {
        return (int)(this.get() / 100000L);
    }

    public int treeId() {
        return (int)(this.get() % 100000L);
    }

    public TreeID clone() {
        return new TreeID(this.partition(), this.treeId());
    }
}

