/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce.partial;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.df.callback.SingleTreePredictions;
import org.apache.mahout.df.data.DataConverter;
import org.apache.mahout.df.data.Dataset;
import org.apache.mahout.df.data.Instance;
import org.apache.mahout.df.mapreduce.Builder;
import org.apache.mahout.df.mapreduce.MapredOutput;
import org.apache.mahout.df.mapreduce.partial.InterResults;
import org.apache.mahout.df.mapreduce.partial.Step1Mapper;
import org.apache.mahout.df.mapreduce.partial.TreeID;
import org.apache.mahout.df.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Step2Mapper
extends Mapper<LongWritable, Text, TreeID, MapredOutput> {
    private static final Logger log = LoggerFactory.getLogger(Step2Mapper.class);
    private TreeID[] keys;
    private Node[] trees;
    private SingleTreePredictions[] callbacks;
    private DataConverter converter;
    private int partition = -1;
    private int instanceId;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        URI[] files = DistributedCache.getCacheFiles((Configuration)conf);
        log.info("DistributedCache.getCacheFiles(): {}", (Object)ArrayUtils.toString((Object)files));
        Preconditions.checkArgument((files != null && files.length >= 2 ? 1 : 0) != 0, (Object)"missing paths from the DistributedCache");
        Path datasetPath = new Path(files[0].getPath());
        Dataset dataset = Dataset.load(conf, datasetPath);
        int numMaps = Builder.getNumMaps(conf);
        int p = conf.getInt("mapred.task.partition", -1);
        int numTrees = Builder.getNbTrees(conf);
        Preconditions.checkArgument((numTrees != -1 ? 1 : 0) != 0, (Object)"numTrees not found !");
        int nbConcerned = Step2Mapper.nbConcerned(numMaps, numTrees, p);
        this.keys = new TreeID[nbConcerned];
        this.trees = new Node[nbConcerned];
        Path forestPath = new Path(files[1].getPath());
        FileSystem fs = forestPath.getFileSystem(conf);
        int numInstances = InterResults.load(fs, forestPath, numMaps, numTrees, p, this.keys, this.trees);
        log.debug("partition: {} numInstances: {}", (Object)p, (Object)numInstances);
        this.configure(p, dataset, this.keys, this.trees, numInstances);
    }

    public static int nbConcerned(int numMaps, int numTrees, int partition) {
        Preconditions.checkArgument((partition >= 0 ? 1 : 0) != 0, (Object)"partition < 0");
        return numTrees - Step1Mapper.nbTrees(numMaps, numTrees, partition);
    }

    public void configure(int partition, Dataset dataset, TreeID[] keys, Node[] trees, int numInstances) {
        this.partition = partition;
        Preconditions.checkArgument((partition >= 0 ? 1 : 0) != 0, (Object)("Wrong partition id : " + partition));
        this.converter = new DataConverter(dataset);
        Preconditions.checkArgument((keys.length == trees.length ? 1 : 0) != 0, (Object)"keys.length != trees.length");
        int nbConcerned = keys.length;
        this.keys = keys;
        this.trees = trees;
        for (TreeID key : keys) {
            Preconditions.checkArgument((key.partition() != partition ? 1 : 0) != 0, (Object)"a tree from this partition was found !");
        }
        this.callbacks = new SingleTreePredictions[nbConcerned];
        for (int index = 0; index < nbConcerned; ++index) {
            this.callbacks[index] = new SingleTreePredictions(numInstances);
        }
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        Instance instance = this.converter.convert(this.instanceId, value.toString());
        for (int index = 0; index < this.keys.length; ++index) {
            int prediction = this.trees[index].classify(instance);
            this.callbacks[index].prediction(index, this.instanceId, prediction);
        }
        ++this.instanceId;
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        for (int index = 0; index < this.keys.length; ++index) {
            TreeID key = new TreeID(this.partition, this.keys[index].treeId());
            context.write((Object)key, (Object)new MapredOutput(this.callbacks[index].getPredictions()));
        }
    }
}

