/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce.partial;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.df.callback.PredictionCallback;
import org.apache.mahout.df.mapreduce.Builder;
import org.apache.mahout.df.mapreduce.MapredOutput;
import org.apache.mahout.df.mapreduce.partial.InterResults;
import org.apache.mahout.df.mapreduce.partial.PartialBuilder;
import org.apache.mahout.df.mapreduce.partial.Step0Job;
import org.apache.mahout.df.mapreduce.partial.Step2Mapper;
import org.apache.mahout.df.mapreduce.partial.TreeID;
import org.apache.mahout.df.node.Node;

public class Step2Job {
    private final Path outputPath;
    private final Path forestPath;
    private final Path datasetPath;
    private final Path dataPath;
    private final Step0Job.Step0Output[] partitions;

    public Step2Job(Path base, Path dataPath, Path datasetPath, Step0Job.Step0Output[] partitions) {
        this.outputPath = new Path(base, "step2.output");
        this.forestPath = new Path(base, "forest");
        this.dataPath = dataPath;
        this.datasetPath = datasetPath;
        this.partitions = partitions;
    }

    public void run(Configuration conf, TreeID[] keys, Node[] trees, PredictionCallback callback) throws IOException, ClassNotFoundException, InterruptedException {
        if (callback == null) {
            return;
        }
        int numTrees = keys.length;
        if (this.outputPath.getFileSystem(conf).exists(this.outputPath)) {
            throw new IOException("Output path already exists : " + this.outputPath);
        }
        int[] sizes = Step0Job.Step0Output.extractSizes(this.partitions);
        InterResults.store(this.forestPath.getFileSystem(conf), this.forestPath, keys, trees, sizes);
        Builder.setNbTrees(conf, numTrees);
        URI[] files = new URI[]{this.datasetPath.toUri(), this.forestPath.toUri()};
        DistributedCache.setCacheFiles((URI[])files, (Configuration)conf);
        Job job = new Job(conf);
        job.setJarByClass(Step2Job.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.dataPath});
        FileOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
        job.setOutputKeyClass(TreeID.class);
        job.setOutputValueClass(MapredOutput.class);
        job.setMapperClass(Step2Mapper.class);
        job.setNumReduceTasks(0);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        if (job.waitForCompletion(true)) {
            this.parseOutput(job, callback);
        }
    }

    protected void parseOutput(Job job, PredictionCallback callback) throws IOException {
        Configuration conf = job.getConfiguration();
        int numMaps = Builder.getNumMaps(conf);
        int numTrees = Builder.getNbTrees(conf);
        int total = 0;
        for (int partition = 0; partition < numMaps; ++partition) {
            total += Step2Mapper.nbConcerned(numMaps, numTrees, partition);
        }
        int[] firstIds = Step0Job.Step0Output.extractFirstIds(this.partitions);
        PartialBuilder.processOutput((JobContext)job, this.outputPath, firstIds, null, null, callback);
    }
}

