/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce.partial;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Step0Job {
    private static final Logger log = LoggerFactory.getLogger(Step0Job.class);
    private final Path outputPath;
    private final Path datasetPath;
    private final Path dataPath;

    public Step0Job(Path base, Path dataPath, Path datasetPath) {
        this.outputPath = new Path(base, "step0.output");
        this.dataPath = dataPath;
        this.datasetPath = datasetPath;
    }

    public Step0Output[] run(Configuration conf) throws IOException, ClassNotFoundException, InterruptedException {
        if (this.outputPath.getFileSystem(conf).exists(this.outputPath)) {
            throw new IOException("Output path already exists : " + this.outputPath);
        }
        URI[] files = new URI[]{this.datasetPath.toUri()};
        DistributedCache.setCacheFiles((URI[])files, (Configuration)conf);
        Job job = new Job(conf);
        job.setJarByClass(Step0Job.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.dataPath});
        FileOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(Step0Output.class);
        job.setMapperClass(Step0Mapper.class);
        job.setNumReduceTasks(0);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.waitForCompletion(true);
        return this.parseOutput((JobContext)job);
    }

    protected Step0Output[] parseOutput(JobContext job) throws IOException {
        Configuration conf = job.getConfiguration();
        log.info("mapred.map.tasks = {}", (Object)conf.getInt("mapred.map.tasks", -1));
        ArrayList<Integer> keys = new ArrayList<Integer>();
        ArrayList<Step0Output> values = new ArrayList<Step0Output>();
        for (Pair record : new SequenceFileDirIterable(this.outputPath, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
            keys.add(((IntWritable)record.getFirst()).get());
            values.add((Step0Output)record.getSecond());
        }
        return Step0Job.processOutput(keys, values);
    }

    protected static Step0Output[] processOutput(List<Integer> keys, List<Step0Output> values) {
        int numMaps = values.size();
        Object[] sorted = new Step0Output[numMaps];
        values.toArray(sorted);
        Arrays.sort(sorted);
        int[] orderedIds = new int[numMaps];
        orderedIds[0] = 0;
        for (int p = 1; p < numMaps; ++p) {
            orderedIds[p] = orderedIds[p - 1] + ((Step0Output)sorted[p - 1]).size;
        }
        for (Step0Output value : values) {
            int order = ArrayUtils.indexOf((Object[])sorted, (Object)value);
            value.firstId = orderedIds[order];
        }
        Step0Output[] reordered = new Step0Output[numMaps];
        for (int p = 0; p < numMaps; ++p) {
            reordered[keys.get((int)p).intValue()] = values.get(p);
        }
        return reordered;
    }

    public static class Step0Output
    implements Writable,
    Comparable<Step0Output>,
    Cloneable {
        private long firstId;
        private int size;

        protected Step0Output() {
        }

        protected Step0Output(long firstId, int size) {
            this.firstId = firstId;
            this.size = size;
        }

        protected long getFirstId() {
            return this.firstId;
        }

        protected int getSize() {
            return this.size;
        }

        public void readFields(DataInput in) throws IOException {
            this.firstId = in.readLong();
            this.size = in.readInt();
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.firstId);
            out.writeInt(this.size);
        }

        public boolean equals(Object other) {
            return other instanceof Step0Output && this.firstId == ((Step0Output)other).firstId;
        }

        public int hashCode() {
            return (int)this.firstId;
        }

        protected Step0Output clone() {
            return new Step0Output(this.firstId, this.size);
        }

        @Override
        public int compareTo(Step0Output obj) {
            if (this.firstId < obj.firstId) {
                return -1;
            }
            if (this.firstId > obj.firstId) {
                return 1;
            }
            return 0;
        }

        public static int[] extractFirstIds(Step0Output[] partitions) {
            int[] ids = new int[partitions.length];
            for (int p = 0; p < partitions.length; ++p) {
                ids[p] = (int)partitions[p].firstId;
            }
            return ids;
        }

        public static int[] extractSizes(Step0Output[] partitions) {
            int[] sizes = new int[partitions.length];
            for (int p = 0; p < partitions.length; ++p) {
                sizes[p] = partitions[p].size;
            }
            return sizes;
        }
    }

    static class Step0Mapper
    extends Mapper<LongWritable, Text, IntWritable, Step0Output> {
        private int partition;
        private int size;
        private Long firstId;

        Step0Mapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.configure(context.getConfiguration().getInt("mapred.task.partition", -1));
        }

        protected void configure(int p) {
            this.partition = p;
            Preconditions.checkArgument((this.partition >= 0 ? 1 : 0) != 0, (String)"Wrong partition id: %d", (Object[])new Object[]{this.partition});
        }

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.firstId == null) {
                this.firstId = key.get();
            }
            ++this.size;
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)new IntWritable(this.partition), (Object)new Step0Output(this.firstId, this.size));
        }
    }
}

