/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce.partial;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.df.DFUtils;
import org.apache.mahout.df.DecisionForest;
import org.apache.mahout.df.builder.TreeBuilder;
import org.apache.mahout.df.callback.PredictionCallback;
import org.apache.mahout.df.mapreduce.Builder;
import org.apache.mahout.df.mapreduce.MapredOutput;
import org.apache.mahout.df.mapreduce.partial.Step0Job;
import org.apache.mahout.df.mapreduce.partial.Step1Mapper;
import org.apache.mahout.df.mapreduce.partial.Step2Job;
import org.apache.mahout.df.mapreduce.partial.TreeID;
import org.apache.mahout.df.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialBuilder
extends Builder {
    private static final Logger log = LoggerFactory.getLogger(PartialBuilder.class);

    public PartialBuilder(TreeBuilder treeBuilder, Path dataPath, Path datasetPath, Long seed) {
        this(treeBuilder, dataPath, datasetPath, seed, new Configuration());
    }

    public PartialBuilder(TreeBuilder treeBuilder, Path dataPath, Path datasetPath, Long seed, Configuration conf) {
        super(treeBuilder, dataPath, datasetPath, seed, conf);
    }

    protected static boolean isStep2(Configuration conf) {
        return conf.getBoolean("debug.mahout.rf.partial.step2", true);
    }

    protected static void setStep2(Configuration conf, boolean value) {
        conf.setBoolean("debug.mahout.rf.partial.step2", value);
    }

    @Override
    protected void configureJob(Job job, int nbTrees, boolean oobEstimate) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setJarByClass(PartialBuilder.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.getDataPath()});
        FileOutputFormat.setOutputPath((Job)job, (Path)this.getOutputPath(conf));
        job.setOutputKeyClass(TreeID.class);
        job.setOutputValueClass(MapredOutput.class);
        job.setMapperClass(Step1Mapper.class);
        job.setNumReduceTasks(0);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
    }

    @Override
    protected DecisionForest parseOutput(Job job, PredictionCallback callback) throws IOException, ClassNotFoundException, InterruptedException {
        Configuration conf = job.getConfiguration();
        int numTrees = Builder.getNbTrees(conf);
        Path outputPath = this.getOutputPath(conf);
        log.info("Computing partitions' first ids...");
        Step0Job step0 = new Step0Job(this.getOutputPath(conf), this.getDataPath(), this.getDatasetPath());
        Step0Job.Step0Output[] partitions = step0.run(new Configuration(conf));
        log.info("Processing the output...");
        TreeID[] keys = new TreeID[numTrees];
        Node[] trees = new Node[numTrees];
        int[] firstIds = Step0Job.Step0Output.extractFirstIds(partitions);
        PartialBuilder.processOutput((JobContext)job, outputPath, firstIds, keys, trees, callback);
        int numMaps = partitions.length;
        if (callback != null && numMaps > 1 && PartialBuilder.isStep2(conf)) {
            log.info("*****************************");
            log.info("Second Step");
            log.info("*****************************");
            Step2Job step2 = new Step2Job(this.getOutputPath(conf), this.getDataPath(), this.getDatasetPath(), partitions);
            step2.run(new Configuration(conf), keys, trees, callback);
        }
        return new DecisionForest(Arrays.asList(trees));
    }

    protected static void processOutput(JobContext job, Path outputPath, int[] firstIds, TreeID[] keys, Node[] trees, PredictionCallback callback) throws IOException {
        Preconditions.checkArgument((keys == null && trees == null || keys != null && trees != null ? 1 : 0) != 0, (Object)"if keys is null, trees should also be null");
        Preconditions.checkArgument((keys == null || keys.length == trees.length ? 1 : 0) != 0, (Object)"keys.length != trees.length");
        Configuration conf = job.getConfiguration();
        FileSystem fs = outputPath.getFileSystem(conf);
        Path[] outfiles = DFUtils.listOutputFiles(fs, outputPath);
        int index = 0;
        for (Path path : outfiles) {
            for (Pair record : new SequenceFileIterable(path, conf)) {
                TreeID key = (TreeID)record.getFirst();
                MapredOutput value = (MapredOutput)record.getSecond();
                if (keys != null) {
                    keys[index] = key;
                }
                if (trees != null) {
                    trees[index] = value.getTree();
                }
                PartialBuilder.processOutput(firstIds, key, value, callback);
                ++index;
            }
        }
        if (keys != null && index != keys.length) {
            throw new IllegalStateException("Some key/values are missing from the output");
        }
    }

    private static void processOutput(int[] firstIds, TreeID key, MapredOutput value, PredictionCallback callback) {
        if (callback != null) {
            int[] predictions = value.getPredictions();
            for (int instanceId = 0; instanceId < predictions.length; ++instanceId) {
                callback.prediction(key.treeId(), firstIds[key.partition()] + instanceId, predictions[instanceId]);
            }
        }
    }
}

