/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce.partial;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.df.mapreduce.partial.TreeID;
import org.apache.mahout.df.node.Node;

public final class InterResults {
    private InterResults() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int load(FileSystem fs, Path forestPath, int numMaps, int numTrees, int partition, TreeID[] keys, Node[] trees) throws IOException {
        Preconditions.checkArgument((keys.length == trees.length ? 1 : 0) != 0, (Object)"keys.length != trees.length");
        FSDataInputStream in = fs.open(forestPath);
        TreeID key = new TreeID();
        int numInstances = -1;
        try {
            for (int p = 0; p < numMaps; ++p) {
                if (p == partition) {
                    numInstances = in.readInt();
                    continue;
                }
                in.readInt();
            }
            int current = 0;
            for (int index = 0; index < numTrees; ++index) {
                key.readFields((DataInput)in);
                if (key.partition() == partition) {
                    Node.read((DataInput)in);
                    continue;
                }
                keys[current] = key.clone();
                trees[current] = Node.read((DataInput)in);
                ++current;
            }
            if (current != keys.length) {
                throw new IllegalStateException("loaded less keys/trees than expected");
            }
        }
        finally {
            in.close();
        }
        return numInstances;
    }

    public static void store(FileSystem fs, Path forestPath, TreeID[] keys, Node[] trees, int[] sizes) throws IOException {
        Preconditions.checkArgument((keys.length == trees.length ? 1 : 0) != 0, (Object)"keys.length != trees.length");
        int numTrees = keys.length;
        int numMaps = sizes.length;
        FSDataOutputStream out = fs.create(forestPath);
        for (int p = 0; p < numMaps; ++p) {
            out.writeInt(sizes[p]);
        }
        for (int index = 0; index < numTrees; ++index) {
            keys[index].write((DataOutput)out);
            trees[index].write((DataOutput)out);
        }
        out.close();
    }
}

