/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce.inmem;

import java.io.IOException;
import java.net.URI;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.df.Bagging;
import org.apache.mahout.df.callback.SingleTreePredictions;
import org.apache.mahout.df.data.Data;
import org.apache.mahout.df.data.DataLoader;
import org.apache.mahout.df.data.Dataset;
import org.apache.mahout.df.mapreduce.Builder;
import org.apache.mahout.df.mapreduce.MapredMapper;
import org.apache.mahout.df.mapreduce.MapredOutput;
import org.apache.mahout.df.mapreduce.inmem.InMemInputFormat;
import org.apache.mahout.df.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemMapper
extends MapredMapper<IntWritable, NullWritable, IntWritable, MapredOutput> {
    private static final Logger log = LoggerFactory.getLogger(InMemMapper.class);
    private Bagging bagging;
    private Random rng;
    private Data data;

    private static Data loadData(Configuration conf, Dataset dataset) throws IOException {
        Path dataPath = Builder.getDistributedCacheFile(conf, 1);
        FileSystem fs = FileSystem.get((URI)dataPath.toUri(), (Configuration)conf);
        return DataLoader.loadData(dataset, fs, dataPath);
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        log.info("Loading the data...");
        this.data = InMemMapper.loadData(conf, this.getDataset());
        log.info("Data loaded : {} instances", (Object)this.data.size());
        this.bagging = new Bagging(this.getTreeBuilder(), this.data);
    }

    protected void map(IntWritable key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
        this.map(key, context);
    }

    protected void map(IntWritable key, Mapper.Context context) throws IOException, InterruptedException {
        SingleTreePredictions callback = null;
        int[] predictions = null;
        if (this.isOobEstimate() && !this.isNoOutput()) {
            callback = new SingleTreePredictions(this.data.size());
            predictions = callback.getPredictions();
        }
        this.initRandom((InMemInputFormat.InMemInputSplit)context.getInputSplit());
        log.debug("Building...");
        Node tree = this.bagging.build(key.get(), this.rng, callback);
        if (!this.isNoOutput()) {
            log.debug("Outputing...");
            MapredOutput mrOut = new MapredOutput(tree, predictions);
            context.write((Object)key, (Object)mrOut);
        }
    }

    protected void initRandom(InMemInputFormat.InMemInputSplit split) {
        if (this.rng == null) {
            Long seed = split.getSeed();
            log.debug("Initialising rng with seed : {}", (Object)seed);
            this.rng = seed == null ? RandomUtils.getRandom() : RandomUtils.getRandom((long)seed);
        }
    }
}

