/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce.inmem;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.df.DFUtils;
import org.apache.mahout.df.DecisionForest;
import org.apache.mahout.df.builder.TreeBuilder;
import org.apache.mahout.df.callback.PredictionCallback;
import org.apache.mahout.df.mapreduce.Builder;
import org.apache.mahout.df.mapreduce.MapredOutput;
import org.apache.mahout.df.mapreduce.inmem.InMemInputFormat;
import org.apache.mahout.df.mapreduce.inmem.InMemMapper;
import org.apache.mahout.df.node.Node;

public class InMemBuilder
extends Builder {
    public InMemBuilder(TreeBuilder treeBuilder, Path dataPath, Path datasetPath, Long seed, Configuration conf) {
        super(treeBuilder, dataPath, datasetPath, seed, conf);
    }

    public InMemBuilder(TreeBuilder treeBuilder, Path dataPath, Path datasetPath) {
        this(treeBuilder, dataPath, datasetPath, null, new Configuration());
    }

    @Override
    protected void configureJob(Job job, int nbTrees, boolean oobEstimate) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setJarByClass(InMemBuilder.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)this.getOutputPath(conf));
        DistributedCache.addCacheFile((URI)this.getDataPath().toUri(), (Configuration)conf);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(MapredOutput.class);
        job.setMapperClass(InMemMapper.class);
        job.setNumReduceTasks(0);
        job.setInputFormatClass(InMemInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
    }

    @Override
    protected DecisionForest parseOutput(Job job, PredictionCallback callback) throws IOException {
        Path[] outfiles;
        Configuration conf = job.getConfiguration();
        HashMap<Integer, MapredOutput> output = new HashMap<Integer, MapredOutput>();
        Path outputPath = this.getOutputPath(conf);
        FileSystem fs = outputPath.getFileSystem(conf);
        for (Path path : outfiles = DFUtils.listOutputFiles(fs, outputPath)) {
            for (Pair record : new SequenceFileIterable(path, conf)) {
                output.put(((IntWritable)record.getFirst()).get(), (MapredOutput)record.getSecond());
            }
        }
        return InMemBuilder.processOutput(output, callback);
    }

    private static DecisionForest processOutput(Map<Integer, MapredOutput> output, PredictionCallback callback) {
        ArrayList<Node> trees = new ArrayList<Node>();
        for (Map.Entry<Integer, MapredOutput> entry : output.entrySet()) {
            MapredOutput value = entry.getValue();
            trees.add(value.getTree());
            if (callback == null) continue;
            int[] predictions = value.getPredictions();
            for (int index = 0; index < predictions.length; ++index) {
                callback.prediction(entry.getKey(), index, predictions[index]);
            }
        }
        return new DecisionForest(trees);
    }
}

