/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.df.builder.TreeBuilder;
import org.apache.mahout.df.data.Dataset;
import org.apache.mahout.df.mapreduce.Builder;

public class MapredMapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Mapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private boolean noOutput;
    private boolean oobEstimate;
    private TreeBuilder treeBuilder;
    private Dataset dataset;

    protected boolean isOobEstimate() {
        return this.oobEstimate;
    }

    protected boolean isNoOutput() {
        return this.noOutput;
    }

    protected TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    protected Dataset getDataset() {
        return this.dataset;
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.configure(!Builder.isOutput(conf), Builder.isOobEstimate(conf), Builder.getTreeBuilder(conf), Builder.loadDataset(conf));
    }

    protected void configure(boolean noOutput, boolean oobEstimate, TreeBuilder treeBuilder, Dataset dataset) {
        Preconditions.checkArgument((treeBuilder != null ? 1 : 0) != 0, (Object)"TreeBuilder not found in the Job parameters");
        this.noOutput = noOutput;
        this.oobEstimate = oobEstimate;
        this.treeBuilder = treeBuilder;
        this.dataset = dataset;
    }
}

