/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.StringUtils;
import org.apache.mahout.df.DecisionForest;
import org.apache.mahout.df.builder.TreeBuilder;
import org.apache.mahout.df.callback.PredictionCallback;
import org.apache.mahout.df.data.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Builder {
    private static final Logger log = LoggerFactory.getLogger(Builder.class);
    private final TreeBuilder treeBuilder;
    private final Path dataPath;
    private final Path datasetPath;
    private final Long seed;
    private final Configuration conf;
    private String outputDirName = "output";

    protected Builder(TreeBuilder treeBuilder, Path dataPath, Path datasetPath, Long seed, Configuration conf) {
        this.treeBuilder = treeBuilder;
        this.dataPath = dataPath;
        this.datasetPath = datasetPath;
        this.seed = seed;
        this.conf = new Configuration(conf);
    }

    protected TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    protected Path getDataPath() {
        return this.dataPath;
    }

    protected Path getDatasetPath() {
        return this.datasetPath;
    }

    protected Long getSeed() {
        return this.seed;
    }

    public static int getNumMaps(Configuration conf) {
        return conf.getInt("mapred.map.tasks", -1);
    }

    protected static boolean isOutput(Configuration conf) {
        return conf.getBoolean("debug.mahout.rf.output", true);
    }

    protected static boolean isOobEstimate(Configuration conf) {
        return conf.getBoolean("mahout.rf.oob", false);
    }

    private static void setOobEstimate(Configuration conf, boolean value) {
        conf.setBoolean("mahout.rf.oob", value);
    }

    public static Long getRandomSeed(Configuration conf) {
        String seed = conf.get("mahout.rf.random.seed");
        if (seed == null) {
            return null;
        }
        return Long.valueOf(seed);
    }

    private static void setRandomSeed(Configuration conf, long seed) {
        conf.setLong("mahout.rf.random.seed", seed);
    }

    public static TreeBuilder getTreeBuilder(Configuration conf) {
        String string = conf.get("mahout.rf.treebuilder");
        if (string == null) {
            return null;
        }
        return (TreeBuilder)StringUtils.fromString(string);
    }

    private static void setTreeBuilder(Configuration conf, TreeBuilder treeBuilder) {
        conf.set("mahout.rf.treebuilder", StringUtils.toString(treeBuilder));
    }

    public static int getNbTrees(Configuration conf) {
        return conf.getInt("mahout.rf.nbtrees", -1);
    }

    public static void setNbTrees(Configuration conf, int nbTrees) {
        Preconditions.checkArgument((nbTrees > 0 ? 1 : 0) != 0, (Object)"nbTrees should be greater than 0");
        conf.setInt("mahout.rf.nbtrees", nbTrees);
    }

    public void setOutputDirName(String name) {
        this.outputDirName = name;
    }

    public Path getOutputPath(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        return new Path(fs.getWorkingDirectory(), this.outputDirName);
    }

    public static Path getDistributedCacheFile(Configuration conf, int index) throws IOException {
        URI[] files = DistributedCache.getCacheFiles((Configuration)conf);
        if (files == null || files.length <= index) {
            throw new IOException("path not found in the DistributedCache");
        }
        return new Path(files[index].getPath());
    }

    public static Dataset loadDataset(Configuration conf) throws IOException {
        Path datasetPath = Builder.getDistributedCacheFile(conf, 0);
        return Dataset.load(conf, datasetPath);
    }

    protected abstract void configureJob(Job var1, int var2, boolean var3) throws IOException;

    protected boolean runJob(Job job) throws ClassNotFoundException, IOException, InterruptedException {
        return job.waitForCompletion(true);
    }

    protected abstract DecisionForest parseOutput(Job var1, PredictionCallback var2) throws IOException, ClassNotFoundException, InterruptedException;

    public DecisionForest build(int nbTrees, PredictionCallback callback) throws IOException, ClassNotFoundException, InterruptedException {
        Path outputPath = this.getOutputPath(this.conf);
        FileSystem fs = outputPath.getFileSystem(this.conf);
        if (fs.exists(outputPath)) {
            throw new IOException("Output path already exists : " + outputPath);
        }
        if (this.seed != null) {
            Builder.setRandomSeed(this.conf, this.seed);
        }
        Builder.setNbTrees(this.conf, nbTrees);
        Builder.setTreeBuilder(this.conf, this.treeBuilder);
        Builder.setOobEstimate(this.conf, callback != null);
        DistributedCache.addCacheFile((URI)this.datasetPath.toUri(), (Configuration)this.conf);
        Job job = new Job(this.conf, "decision forest builder");
        log.debug("Configuring the job...");
        this.configureJob(job, nbTrees, callback != null);
        log.debug("Running the job...");
        if (!this.runJob(job)) {
            log.error("Job failed!");
            return null;
        }
        if (Builder.isOutput(this.conf)) {
            log.debug("Parsing the output...");
            DecisionForest forest = this.parseOutput(job, callback);
            HadoopUtil.delete(this.conf, outputPath);
            return forest;
        }
        return null;
    }

    public static void sortSplits(InputSplit[] splits) {
        Arrays.sort(splits, new Comparator<InputSplit>(){

            @Override
            public int compare(InputSplit a, InputSplit b) {
                try {
                    long left = a.getLength();
                    long right = b.getLength();
                    if (left == right) {
                        return 0;
                    }
                    if (left < right) {
                        return 1;
                    }
                    return -1;
                }
                catch (IOException ie) {
                    throw new IllegalStateException("Problem getting input split size", ie);
                }
                catch (InterruptedException ie) {
                    throw new IllegalStateException("Problem getting input split size", ie);
                }
            }
        });
    }
}

