/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.data;

import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.mahout.df.data.Dataset;
import org.apache.mahout.df.data.DescriptorException;

public final class DescriptorUtils {
    private DescriptorUtils() {
    }

    public static Dataset.Attribute[] parseDescriptor(String descriptor) throws DescriptorException {
        StringTokenizer tokenizer = new StringTokenizer(descriptor);
        Dataset.Attribute[] attributes = new Dataset.Attribute[tokenizer.countTokens()];
        for (int attr = 0; attr < attributes.length; ++attr) {
            String token = tokenizer.nextToken().toUpperCase(Locale.ENGLISH);
            if ("I".equals(token)) {
                attributes[attr] = Dataset.Attribute.IGNORED;
                continue;
            }
            if ("N".equals(token)) {
                attributes[attr] = Dataset.Attribute.NUMERICAL;
                continue;
            }
            if ("C".equals(token)) {
                attributes[attr] = Dataset.Attribute.CATEGORICAL;
                continue;
            }
            if ("L".equals(token)) {
                attributes[attr] = Dataset.Attribute.LABEL;
                continue;
            }
            throw new DescriptorException("Bad Token : " + token);
        }
        return attributes;
    }

    public static String generateDescriptor(String description) throws DescriptorException {
        StringTokenizer tokenizer = new StringTokenizer(description, " ");
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return DescriptorUtils.generateDescriptor(tokens);
    }

    public static String generateDescriptor(Iterable<String> tokens) throws DescriptorException {
        StringBuilder descriptor = new StringBuilder();
        int multiplicator = 0;
        for (String token : tokens) {
            try {
                int number = Integer.parseInt(token);
                if (number <= 0) {
                    throw new DescriptorException("Multiplicator (" + number + ") must be > 0");
                }
                if (multiplicator > 0) {
                    throw new DescriptorException("A multiplicator cannot be followed by another multiplicator");
                }
                multiplicator = number;
            }
            catch (NumberFormatException e) {
                if (multiplicator == 0) {
                    multiplicator = 1;
                }
                for (int index = 0; index < multiplicator; ++index) {
                    descriptor.append(token).append(' ');
                }
                multiplicator = 0;
            }
        }
        return descriptor.toString().trim();
    }
}

