/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.data;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.mahout.df.DFUtils;

public class Dataset
implements Writable {
    private Attribute[] attributes;
    private String[] labels;
    private int[] ignored;
    private String[][] values;
    private int labelId;
    private int nbInstances;

    private Dataset() {
    }

    protected Dataset(Attribute[] attrs, List<String>[] values, int nbInstances) {
        Dataset.validateValues(attrs, values);
        int nbattrs = Dataset.countAttributes(attrs);
        this.attributes = new Attribute[nbattrs];
        this.values = new String[nbattrs][];
        this.ignored = new int[attrs.length - (nbattrs + 1)];
        this.labelId = -1;
        int ignoredId = 0;
        int ind = 0;
        for (int attr = 0; attr < attrs.length; ++attr) {
            if (attrs[attr].isIgnored()) {
                this.ignored[ignoredId++] = attr;
                continue;
            }
            if (attrs[attr].isLabel()) {
                if (this.labelId != -1) {
                    throw new IllegalStateException("Label found more than once");
                }
                this.labelId = attr;
                continue;
            }
            if (attrs[attr].isCategorical()) {
                this.values[ind] = new String[values[attr].size()];
                values[attr].toArray(this.values[ind]);
            }
            this.attributes[ind++] = attrs[attr];
        }
        if (this.labelId == -1) {
            throw new IllegalStateException("Label not found");
        }
        this.labels = new String[values[this.labelId].size()];
        values[this.labelId].toArray(this.labels);
        this.nbInstances = nbInstances;
    }

    public String[] labels() {
        return Arrays.copyOf(this.labels, this.labels.length);
    }

    public int nblabels() {
        return this.labels.length;
    }

    public int getLabelId() {
        return this.labelId;
    }

    public int nbInstances() {
        return this.nbInstances;
    }

    public int labelCode(String label) {
        return ArrayUtils.indexOf((Object[])this.labels, (Object)label);
    }

    public String getLabel(int code) {
        return this.labels[code];
    }

    public int valueOf(int attr, String token) {
        Preconditions.checkArgument((!this.isNumerical(attr) ? 1 : 0) != 0, (Object)"Only for CATEGORICAL attributes");
        Preconditions.checkArgument((this.values != null ? 1 : 0) != 0, (Object)"Values not found");
        return ArrayUtils.indexOf((Object[])this.values[attr], (Object)token);
    }

    public int[] getIgnored() {
        return this.ignored;
    }

    protected static int countAttributes(Attribute[] attrs) {
        int nbattrs = 0;
        for (Attribute attr1 : attrs) {
            if (!attr1.isNumerical() && !attr1.isCategorical()) continue;
            ++nbattrs;
        }
        return nbattrs;
    }

    private static void validateValues(Attribute[] attrs, List<String>[] values) {
        Preconditions.checkArgument((attrs.length == values.length ? 1 : 0) != 0, (Object)"attrs.length != values.length");
        for (int attr = 0; attr < attrs.length; ++attr) {
            Preconditions.checkArgument((!attrs[attr].isCategorical() || values[attr] != null ? 1 : 0) != 0, (Object)("values not found for attribute " + attr));
        }
    }

    public int nbAttributes() {
        return this.attributes.length;
    }

    public boolean isNumerical(int attr) {
        return this.attributes[attr].isNumerical();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Dataset)) {
            return false;
        }
        Dataset dataset = (Dataset)obj;
        if (!Arrays.equals((Object[])this.attributes, (Object[])dataset.attributes)) {
            return false;
        }
        if (!Arrays.equals(this.labels, dataset.labels)) {
            return false;
        }
        for (int attr = 0; attr < this.nbAttributes(); ++attr) {
            if (Arrays.equals(this.values[attr], dataset.values[attr])) continue;
            return false;
        }
        return this.labelId == dataset.labelId && this.nbInstances == dataset.nbInstances;
    }

    public int hashCode() {
        int hashCode = this.labelId + 31 * this.nbInstances;
        for (Attribute attribute : this.attributes) {
            hashCode = 31 * hashCode + attribute.hashCode();
        }
        for (String string : this.labels) {
            hashCode = 31 * hashCode + string.hashCode();
        }
        String[][] stringArray = this.values;
        int len$ = stringArray.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] stringArray2;
            for (String value : stringArray2 = stringArray[i$]) {
                hashCode = 31 * hashCode + value.hashCode();
            }
        }
        return hashCode;
    }

    public static Dataset load(Configuration conf, Path path) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        FSDataInputStream input = fs.open(path);
        Dataset dataset = Dataset.read((DataInput)input);
        input.close();
        return dataset;
    }

    public static Dataset read(DataInput in) throws IOException {
        Dataset dataset = new Dataset();
        dataset.readFields(in);
        return dataset;
    }

    public void readFields(DataInput in) throws IOException {
        int attr;
        int nbAttributes = in.readInt();
        this.attributes = new Attribute[nbAttributes];
        for (attr = 0; attr < nbAttributes; ++attr) {
            String name = WritableUtils.readString((DataInput)in);
            this.attributes[attr] = Attribute.valueOf(name);
        }
        this.labels = WritableUtils.readStringArray((DataInput)in);
        this.ignored = DFUtils.readIntArray(in);
        this.values = new String[nbAttributes][];
        for (attr = 0; attr < nbAttributes; ++attr) {
            if (!this.attributes[attr].isCategorical()) continue;
            this.values[attr] = WritableUtils.readStringArray((DataInput)in);
        }
        this.labelId = in.readInt();
        this.nbInstances = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.attributes.length);
        for (Attribute attribute : this.attributes) {
            WritableUtils.writeString((DataOutput)out, (String)attribute.name());
        }
        WritableUtils.writeStringArray((DataOutput)out, (String[])this.labels);
        DFUtils.writeArray(out, this.ignored);
        for (Attribute attribute : this.values) {
            if (attribute == null) continue;
            WritableUtils.writeStringArray((DataOutput)out, (String[])attribute);
        }
        out.writeInt(this.labelId);
        out.writeInt(this.nbInstances);
    }

    public static enum Attribute {
        IGNORED,
        NUMERICAL,
        CATEGORICAL,
        LABEL;


        public boolean isNumerical() {
            return this == NUMERICAL;
        }

        public boolean isCategorical() {
            return this == CATEGORICAL;
        }

        public boolean isLabel() {
            return this == LABEL;
        }

        public boolean isIgnored() {
            return this == IGNORED;
        }
    }
}

