/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.data;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.mahout.df.data.Dataset;
import org.apache.mahout.df.data.Instance;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConverter {
    private static final Logger log = LoggerFactory.getLogger(DataConverter.class);
    private final Dataset dataset;

    public DataConverter(Dataset dataset) {
        this.dataset = dataset;
    }

    public Instance convert(int id, String string) {
        int nball = this.dataset.nbAttributes() + this.dataset.getIgnored().length + 1;
        StringTokenizer tokenizer = new StringTokenizer(string, ", ");
        Preconditions.checkArgument((tokenizer.countTokens() == nball ? 1 : 0) != 0, (Object)"Wrong number of attributes in the string");
        int nbattrs = this.dataset.nbAttributes();
        DenseVector vector = new DenseVector(nbattrs);
        int aId = 0;
        int label = -1;
        for (int attr = 0; attr < nball; ++attr) {
            String token = tokenizer.nextToken().trim();
            if (ArrayUtils.contains((int[])this.dataset.getIgnored(), (int)attr)) continue;
            if ("?".equals(token)) {
                return null;
            }
            if (attr == this.dataset.getLabelId()) {
                label = this.dataset.labelCode(token);
                if (label != -1) continue;
                log.error("label token: {} dataset.labels: {}", (Object)token, (Object)Arrays.toString(this.dataset.labels()));
                throw new IllegalStateException("Label value (" + token + ") not known");
            }
            if (this.dataset.isNumerical(aId)) {
                vector.set(aId++, Double.parseDouble(token));
                continue;
            }
            vector.set(aId, (double)this.dataset.valueOf(aId, token));
            ++aId;
        }
        if (label == -1) {
            log.error("Label not found, instance id : {}, string : {}", (Object)id, (Object)string);
            throw new IllegalStateException("Label not found!");
        }
        return new Instance(id, (Vector)vector, label);
    }
}

