/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.callback;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.mahout.df.callback.PredictionCallback;

public class SingleTreePredictions
implements PredictionCallback {
    private final int[] predictions;
    private Integer treeId;

    public SingleTreePredictions(int nbInstances) {
        this.predictions = new int[nbInstances];
        Arrays.fill(this.predictions, -1);
    }

    @Override
    public void prediction(int treeId, int instanceId, int prediction) {
        if (this.treeId == null) {
            this.treeId = treeId;
        } else {
            Preconditions.checkArgument((this.treeId == treeId ? 1 : 0) != 0, (Object)"the predictions does not belong to the same tree");
        }
        this.predictions[instanceId] = prediction;
    }

    public int[] getPredictions() {
        return this.predictions;
    }
}

