/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.callback;

import org.apache.mahout.df.callback.PredictionCallback;
import org.apache.mahout.df.data.Data;

public class MeanTreeCollector
implements PredictionCallback {
    private final int[] nbErrors;
    private final int[] nbPredictions;
    private final Data data;

    public MeanTreeCollector(Data data, int nbtrees) {
        this.nbErrors = new int[nbtrees];
        this.nbPredictions = new int[nbtrees];
        this.data = data;
    }

    public double meanTreeError() {
        double sumerror = 0.0;
        for (int treeId = 0; treeId < this.nbErrors.length; ++treeId) {
            if (this.nbPredictions[treeId] == 0) continue;
            sumerror += (double)this.nbErrors[treeId] / (double)this.nbPredictions[treeId];
        }
        return sumerror / (double)this.nbErrors.length;
    }

    @Override
    public void prediction(int treeId, int instanceId, int prediction) {
        if (prediction == -1) {
            return;
        }
        int n = treeId;
        this.nbPredictions[n] = this.nbPredictions[n] + 1;
        if (this.data.get(instanceId).getLabel() != prediction) {
            int n2 = treeId;
            this.nbErrors[n2] = this.nbErrors[n2] + 1;
        }
    }
}

