/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.callback;

import java.util.Arrays;
import java.util.Random;
import org.apache.mahout.df.callback.PredictionCallback;
import org.apache.mahout.df.data.DataUtils;

public class ForestPredictions
implements PredictionCallback {
    private final int[][] predictions;

    public ForestPredictions(int nbInstances, int nblabels) {
        this.predictions = new int[nbInstances][];
        for (int index = 0; index < this.predictions.length; ++index) {
            this.predictions[index] = new int[nblabels];
        }
    }

    @Override
    public void prediction(int treeId, int instanceId, int prediction) {
        if (prediction != -1) {
            int[] nArray = this.predictions[instanceId];
            int n = prediction;
            nArray[n] = nArray[n] + 1;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ForestPredictions)) {
            return false;
        }
        ForestPredictions fp = (ForestPredictions)obj;
        if (this.predictions.length != fp.predictions.length) {
            return false;
        }
        for (int i = 0; i < this.predictions.length; ++i) {
            if (Arrays.equals(this.predictions[i], fp.predictions[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int[][] arr$ = this.predictions;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] row;
            for (int value : row = arr$[i$]) {
                hashCode = 31 * hashCode + value;
            }
        }
        return hashCode;
    }

    public int[] computePredictions(Random rng) {
        int[] result = new int[this.predictions.length];
        Arrays.fill(result, -1);
        for (int index = 0; index < this.predictions.length; ++index) {
            if (DataUtils.sum(this.predictions[index]) == 0) continue;
            result[index] = DataUtils.maxindex(rng, this.predictions[index]);
        }
        return result;
    }
}

