/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.df.DFUtils;
import org.apache.mahout.df.callback.PredictionCallback;
import org.apache.mahout.df.data.Data;
import org.apache.mahout.df.data.DataUtils;
import org.apache.mahout.df.data.Instance;
import org.apache.mahout.df.node.Node;

public class DecisionForest
implements Writable {
    private final List<Node> trees;

    protected DecisionForest() {
        this.trees = new ArrayList<Node>();
    }

    public DecisionForest(List<Node> trees) {
        Preconditions.checkArgument((trees != null && !trees.isEmpty() ? 1 : 0) != 0, (Object)"trees argument must not be null or empty");
        this.trees = trees;
    }

    public List<Node> getTrees() {
        return this.trees;
    }

    public void classify(Data data, PredictionCallback callback) {
        Preconditions.checkArgument((callback != null ? 1 : 0) != 0, (Object)"callback must not be null");
        if (data.isEmpty()) {
            return;
        }
        for (int treeId = 0; treeId < this.trees.size(); ++treeId) {
            Node tree = this.trees.get(treeId);
            for (int index = 0; index < data.size(); ++index) {
                int prediction = tree.classify(data.get(index));
                callback.prediction(treeId, index, prediction);
            }
        }
    }

    public int classify(Random rng, Instance instance) {
        int[] predictions = new int[this.trees.size()];
        for (Node tree : this.trees) {
            int prediction = tree.classify(instance);
            if (prediction == -1) continue;
            int n = prediction;
            predictions[n] = predictions[n] + 1;
        }
        if (DataUtils.sum(predictions) == 0) {
            return -1;
        }
        return DataUtils.maxindex(rng, predictions);
    }

    public long meanNbNodes() {
        long sum = 0L;
        for (Node tree : this.trees) {
            sum += tree.nbNodes();
        }
        return sum / (long)this.trees.size();
    }

    public long nbNodes() {
        long sum = 0L;
        for (Node tree : this.trees) {
            sum += tree.nbNodes();
        }
        return sum;
    }

    public long meanMaxDepth() {
        long sum = 0L;
        for (Node tree : this.trees) {
            sum += tree.maxDepth();
        }
        return sum / (long)this.trees.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DecisionForest)) {
            return false;
        }
        DecisionForest rf = (DecisionForest)obj;
        return this.trees.size() == rf.getTrees().size() && this.trees.containsAll(rf.getTrees());
    }

    public int hashCode() {
        return ((Object)this.trees).hashCode();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.trees.size());
        for (Node tree : this.trees) {
            tree.write(dataOutput);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        for (int i = 0; i < size; ++i) {
            this.trees.add(Node.read(dataInput));
        }
    }

    public static DecisionForest read(DataInput dataInput) throws IOException {
        DecisionForest forest = new DecisionForest();
        forest.readFields(dataInput);
        return forest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DecisionForest load(Configuration conf, Path forestPath) throws IOException {
        FileSystem fs = forestPath.getFileSystem(conf);
        Path[] files = fs.getFileStatus(forestPath).isDir() ? DFUtils.listOutputFiles(fs, forestPath) : new Path[]{forestPath};
        DecisionForest forest = null;
        for (Path path : files) {
            FSDataInputStream dataInput = new FSDataInputStream((InputStream)fs.open(path));
            try {
                if (forest == null) {
                    forest = DecisionForest.read((DataInput)dataInput);
                    continue;
                }
                forest.readFields((DataInput)dataInput);
            }
            finally {
                dataInput.close();
            }
        }
        return forest;
    }
}

